@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devspaces.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Contains information used to connect to a Kubernetes cluster
 * @property instanceType Gets the Instance type.
 * Expected value is 'Kubernetes'.
 * @property kubeConfig Gets the kubeconfig for the cluster.
 */
public data class KubernetesConnectionDetailsResponse(
    public val instanceType: String,
    public val kubeConfig: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devspaces.outputs.KubernetesConnectionDetailsResponse): KubernetesConnectionDetailsResponse = KubernetesConnectionDetailsResponse(
            instanceType = javaType.instanceType(),
            kubeConfig = javaType.kubeConfig().map({ args0 -> args0 }).orElse(null),
        )
    }
}
