@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devspaces.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Model representing SKU for Azure Dev Spaces Controller.
 * @property name The name of the SKU for Azure Dev Spaces Controller.
 * @property tier The tier of the SKU for Azure Dev Spaces Controller.
 */
public data class SkuResponse(
    public val name: String,
    public val tier: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devspaces.outputs.SkuResponse): SkuResponse = SkuResponse(
            name = javaType.name(),
            tier = javaType.tier().map({ args0 -> args0 }).orElse(null),
        )
    }
}
