@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [ArtifactSource].
 */
@PulumiTagMarker
public class ArtifactSourceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ArtifactSourceArgs = ArtifactSourceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ArtifactSourceArgsBuilder.() -> Unit) {
        val builder = ArtifactSourceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ArtifactSource {
        val builtJavaResource =
            com.pulumi.azurenative.devtestlab.ArtifactSource(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ArtifactSource(builtJavaResource)
    }
}

/**
 * Properties of an artifact source.
 * Azure REST API version: 2018-09-15. Prior API version in Azure Native 1.x: 2018-09-15.
 * Other available API versions: 2016-05-15.
 * ## Example Usage
 * ### ArtifactSources_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var artifactSource = new AzureNative.DevTestLab.ArtifactSource("artifactSource", new()
 *     {
 *         ArmTemplateFolderPath = "{armTemplateFolderPath}",
 *         BranchRef = "{branchRef}",
 *         DisplayName = "{displayName}",
 *         FolderPath = "{folderPath}",
 *         LabName = "{labName}",
 *         Name = "{artifactSourceName}",
 *         ResourceGroupName = "resourceGroupName",
 *         SecurityToken = "{securityToken}",
 *         SourceType = "{VsoGit|GitHub|StorageAccount}",
 *         Status = "{Enabled|Disabled}",
 *         Tags =
 *         {
 *             { "tagName1", "tagValue1" },
 *         },
 *         Uri = "{artifactSourceUri}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/devtestlab/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devtestlab.NewArtifactSource(ctx, "artifactSource", &devtestlab.ArtifactSourceArgs{
 * 			ArmTemplateFolderPath: pulumi.String("{armTemplateFolderPath}"),
 * 			BranchRef:             pulumi.String("{branchRef}"),
 * 			DisplayName:           pulumi.String("{displayName}"),
 * 			FolderPath:            pulumi.String("{folderPath}"),
 * 			LabName:               pulumi.String("{labName}"),
 * 			Name:                  pulumi.String("{artifactSourceName}"),
 * 			ResourceGroupName:     pulumi.String("resourceGroupName"),
 * 			SecurityToken:         pulumi.String("{securityToken}"),
 * 			SourceType:            pulumi.String("{VsoGit|GitHub|StorageAccount}"),
 * 			Status:                pulumi.String("{Enabled|Disabled}"),
 * 			Tags: pulumi.StringMap{
 * 				"tagName1": pulumi.String("tagValue1"),
 * 			},
 * 			Uri: pulumi.String("{artifactSourceUri}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.devtestlab.ArtifactSource;
 * import com.pulumi.azurenative.devtestlab.ArtifactSourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var artifactSource = new ArtifactSource("artifactSource", ArtifactSourceArgs.builder()
 *             .armTemplateFolderPath("{armTemplateFolderPath}")
 *             .branchRef("{branchRef}")
 *             .displayName("{displayName}")
 *             .folderPath("{folderPath}")
 *             .labName("{labName}")
 *             .name("{artifactSourceName}")
 *             .resourceGroupName("resourceGroupName")
 *             .securityToken("{securityToken}")
 *             .sourceType("{VsoGit|GitHub|StorageAccount}")
 *             .status("{Enabled|Disabled}")
 *             .tags(Map.of("tagName1", "tagValue1"))
 *             .uri("{artifactSourceUri}")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:devtestlab:ArtifactSource {artifactSourceName} /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/artifactsources/{name}
 * ```
 */
public class ArtifactSource internal constructor(
    override val javaResource: com.pulumi.azurenative.devtestlab.ArtifactSource,
) : KotlinCustomResource(javaResource, ArtifactSourceMapper) {
    /**
     * The folder containing Azure Resource Manager templates.
     */
    public val armTemplateFolderPath: Output<String>?
        get() = javaResource.armTemplateFolderPath().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The artifact source's branch reference.
     */
    public val branchRef: Output<String>?
        get() = javaResource.branchRef().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The artifact source's creation date.
     */
    public val createdDate: Output<String>
        get() = javaResource.createdDate().applyValue({ args0 -> args0 })

    /**
     * The artifact source's display name.
     */
    public val displayName: Output<String>?
        get() = javaResource.displayName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The folder containing artifacts.
     */
    public val folderPath: Output<String>?
        get() = javaResource.folderPath().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The location of the resource.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning status of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The security token to authenticate to the artifact source.
     */
    public val securityToken: Output<String>?
        get() = javaResource.securityToken().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The artifact source's type.
     */
    public val sourceType: Output<String>?
        get() = javaResource.sourceType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Indicates if the artifact source is enabled (values: Enabled, Disabled).
     */
    public val status: Output<String>?
        get() = javaResource.status().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The tags of the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The unique immutable identifier of a resource (Guid).
     */
    public val uniqueIdentifier: Output<String>
        get() = javaResource.uniqueIdentifier().applyValue({ args0 -> args0 })

    /**
     * The artifact source's URI.
     */
    public val uri: Output<String>?
        get() = javaResource.uri().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object ArtifactSourceMapper : ResourceMapper<ArtifactSource> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.devtestlab.ArtifactSource::class == javaResource::class

    override fun map(javaResource: Resource): ArtifactSource = ArtifactSource(
        javaResource as
            com.pulumi.azurenative.devtestlab.ArtifactSource,
    )
}

/**
 * @see [ArtifactSource].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ArtifactSource].
 */
public suspend fun artifactSource(
    name: String,
    block: suspend ArtifactSourceResourceBuilder.() -> Unit,
): ArtifactSource {
    val builder = ArtifactSourceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ArtifactSource].
 * @param name The _unique_ name of the resulting resource.
 */
public fun artifactSource(name: String): ArtifactSource {
    val builder = ArtifactSourceResourceBuilder()
    builder.name(name)
    return builder.build()
}
