@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin

import com.pulumi.azurenative.devtestlab.DevtestlabFunctions.getArtifactSourcePlain
import com.pulumi.azurenative.devtestlab.DevtestlabFunctions.getCustomImagePlain
import com.pulumi.azurenative.devtestlab.DevtestlabFunctions.getDiskPlain
import com.pulumi.azurenative.devtestlab.DevtestlabFunctions.getEnvironmentPlain
import com.pulumi.azurenative.devtestlab.DevtestlabFunctions.getFormulaPlain
import com.pulumi.azurenative.devtestlab.DevtestlabFunctions.getGlobalSchedulePlain
import com.pulumi.azurenative.devtestlab.DevtestlabFunctions.getLabPlain
import com.pulumi.azurenative.devtestlab.DevtestlabFunctions.getNotificationChannelPlain
import com.pulumi.azurenative.devtestlab.DevtestlabFunctions.getPolicyPlain
import com.pulumi.azurenative.devtestlab.DevtestlabFunctions.getSchedulePlain
import com.pulumi.azurenative.devtestlab.DevtestlabFunctions.getSecretPlain
import com.pulumi.azurenative.devtestlab.DevtestlabFunctions.getServiceFabricPlain
import com.pulumi.azurenative.devtestlab.DevtestlabFunctions.getServiceFabricSchedulePlain
import com.pulumi.azurenative.devtestlab.DevtestlabFunctions.getServiceRunnerPlain
import com.pulumi.azurenative.devtestlab.DevtestlabFunctions.getUserPlain
import com.pulumi.azurenative.devtestlab.DevtestlabFunctions.getVirtualMachinePlain
import com.pulumi.azurenative.devtestlab.DevtestlabFunctions.getVirtualMachineRdpFileContentsPlain
import com.pulumi.azurenative.devtestlab.DevtestlabFunctions.getVirtualMachineSchedulePlain
import com.pulumi.azurenative.devtestlab.DevtestlabFunctions.getVirtualNetworkPlain
import com.pulumi.azurenative.devtestlab.DevtestlabFunctions.listLabVhdsPlain
import com.pulumi.azurenative.devtestlab.DevtestlabFunctions.listScheduleApplicablePlain
import com.pulumi.azurenative.devtestlab.DevtestlabFunctions.listServiceFabricApplicableSchedulesPlain
import com.pulumi.azurenative.devtestlab.DevtestlabFunctions.listVirtualMachineApplicableSchedulesPlain
import com.pulumi.azurenative.devtestlab.kotlin.inputs.GetArtifactSourcePlainArgs
import com.pulumi.azurenative.devtestlab.kotlin.inputs.GetArtifactSourcePlainArgsBuilder
import com.pulumi.azurenative.devtestlab.kotlin.inputs.GetCustomImagePlainArgs
import com.pulumi.azurenative.devtestlab.kotlin.inputs.GetCustomImagePlainArgsBuilder
import com.pulumi.azurenative.devtestlab.kotlin.inputs.GetDiskPlainArgs
import com.pulumi.azurenative.devtestlab.kotlin.inputs.GetDiskPlainArgsBuilder
import com.pulumi.azurenative.devtestlab.kotlin.inputs.GetEnvironmentPlainArgs
import com.pulumi.azurenative.devtestlab.kotlin.inputs.GetEnvironmentPlainArgsBuilder
import com.pulumi.azurenative.devtestlab.kotlin.inputs.GetFormulaPlainArgs
import com.pulumi.azurenative.devtestlab.kotlin.inputs.GetFormulaPlainArgsBuilder
import com.pulumi.azurenative.devtestlab.kotlin.inputs.GetGlobalSchedulePlainArgs
import com.pulumi.azurenative.devtestlab.kotlin.inputs.GetGlobalSchedulePlainArgsBuilder
import com.pulumi.azurenative.devtestlab.kotlin.inputs.GetLabPlainArgs
import com.pulumi.azurenative.devtestlab.kotlin.inputs.GetLabPlainArgsBuilder
import com.pulumi.azurenative.devtestlab.kotlin.inputs.GetNotificationChannelPlainArgs
import com.pulumi.azurenative.devtestlab.kotlin.inputs.GetNotificationChannelPlainArgsBuilder
import com.pulumi.azurenative.devtestlab.kotlin.inputs.GetPolicyPlainArgs
import com.pulumi.azurenative.devtestlab.kotlin.inputs.GetPolicyPlainArgsBuilder
import com.pulumi.azurenative.devtestlab.kotlin.inputs.GetSchedulePlainArgs
import com.pulumi.azurenative.devtestlab.kotlin.inputs.GetSchedulePlainArgsBuilder
import com.pulumi.azurenative.devtestlab.kotlin.inputs.GetSecretPlainArgs
import com.pulumi.azurenative.devtestlab.kotlin.inputs.GetSecretPlainArgsBuilder
import com.pulumi.azurenative.devtestlab.kotlin.inputs.GetServiceFabricPlainArgs
import com.pulumi.azurenative.devtestlab.kotlin.inputs.GetServiceFabricPlainArgsBuilder
import com.pulumi.azurenative.devtestlab.kotlin.inputs.GetServiceFabricSchedulePlainArgs
import com.pulumi.azurenative.devtestlab.kotlin.inputs.GetServiceFabricSchedulePlainArgsBuilder
import com.pulumi.azurenative.devtestlab.kotlin.inputs.GetServiceRunnerPlainArgs
import com.pulumi.azurenative.devtestlab.kotlin.inputs.GetServiceRunnerPlainArgsBuilder
import com.pulumi.azurenative.devtestlab.kotlin.inputs.GetUserPlainArgs
import com.pulumi.azurenative.devtestlab.kotlin.inputs.GetUserPlainArgsBuilder
import com.pulumi.azurenative.devtestlab.kotlin.inputs.GetVirtualMachinePlainArgs
import com.pulumi.azurenative.devtestlab.kotlin.inputs.GetVirtualMachinePlainArgsBuilder
import com.pulumi.azurenative.devtestlab.kotlin.inputs.GetVirtualMachineRdpFileContentsPlainArgs
import com.pulumi.azurenative.devtestlab.kotlin.inputs.GetVirtualMachineRdpFileContentsPlainArgsBuilder
import com.pulumi.azurenative.devtestlab.kotlin.inputs.GetVirtualMachineSchedulePlainArgs
import com.pulumi.azurenative.devtestlab.kotlin.inputs.GetVirtualMachineSchedulePlainArgsBuilder
import com.pulumi.azurenative.devtestlab.kotlin.inputs.GetVirtualNetworkPlainArgs
import com.pulumi.azurenative.devtestlab.kotlin.inputs.GetVirtualNetworkPlainArgsBuilder
import com.pulumi.azurenative.devtestlab.kotlin.inputs.ListLabVhdsPlainArgs
import com.pulumi.azurenative.devtestlab.kotlin.inputs.ListLabVhdsPlainArgsBuilder
import com.pulumi.azurenative.devtestlab.kotlin.inputs.ListScheduleApplicablePlainArgs
import com.pulumi.azurenative.devtestlab.kotlin.inputs.ListScheduleApplicablePlainArgsBuilder
import com.pulumi.azurenative.devtestlab.kotlin.inputs.ListServiceFabricApplicableSchedulesPlainArgs
import com.pulumi.azurenative.devtestlab.kotlin.inputs.ListServiceFabricApplicableSchedulesPlainArgsBuilder
import com.pulumi.azurenative.devtestlab.kotlin.inputs.ListVirtualMachineApplicableSchedulesPlainArgs
import com.pulumi.azurenative.devtestlab.kotlin.inputs.ListVirtualMachineApplicableSchedulesPlainArgsBuilder
import com.pulumi.azurenative.devtestlab.kotlin.outputs.GetArtifactSourceResult
import com.pulumi.azurenative.devtestlab.kotlin.outputs.GetCustomImageResult
import com.pulumi.azurenative.devtestlab.kotlin.outputs.GetDiskResult
import com.pulumi.azurenative.devtestlab.kotlin.outputs.GetEnvironmentResult
import com.pulumi.azurenative.devtestlab.kotlin.outputs.GetFormulaResult
import com.pulumi.azurenative.devtestlab.kotlin.outputs.GetGlobalScheduleResult
import com.pulumi.azurenative.devtestlab.kotlin.outputs.GetLabResult
import com.pulumi.azurenative.devtestlab.kotlin.outputs.GetNotificationChannelResult
import com.pulumi.azurenative.devtestlab.kotlin.outputs.GetPolicyResult
import com.pulumi.azurenative.devtestlab.kotlin.outputs.GetScheduleResult
import com.pulumi.azurenative.devtestlab.kotlin.outputs.GetSecretResult
import com.pulumi.azurenative.devtestlab.kotlin.outputs.GetServiceFabricResult
import com.pulumi.azurenative.devtestlab.kotlin.outputs.GetServiceFabricScheduleResult
import com.pulumi.azurenative.devtestlab.kotlin.outputs.GetServiceRunnerResult
import com.pulumi.azurenative.devtestlab.kotlin.outputs.GetUserResult
import com.pulumi.azurenative.devtestlab.kotlin.outputs.GetVirtualMachineRdpFileContentsResult
import com.pulumi.azurenative.devtestlab.kotlin.outputs.GetVirtualMachineResult
import com.pulumi.azurenative.devtestlab.kotlin.outputs.GetVirtualMachineScheduleResult
import com.pulumi.azurenative.devtestlab.kotlin.outputs.GetVirtualNetworkResult
import com.pulumi.azurenative.devtestlab.kotlin.outputs.ListLabVhdsResult
import com.pulumi.azurenative.devtestlab.kotlin.outputs.ListScheduleApplicableResult
import com.pulumi.azurenative.devtestlab.kotlin.outputs.ListServiceFabricApplicableSchedulesResult
import com.pulumi.azurenative.devtestlab.kotlin.outputs.ListVirtualMachineApplicableSchedulesResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.devtestlab.kotlin.outputs.GetArtifactSourceResult.Companion.toKotlin as getArtifactSourceResultToKotlin
import com.pulumi.azurenative.devtestlab.kotlin.outputs.GetCustomImageResult.Companion.toKotlin as getCustomImageResultToKotlin
import com.pulumi.azurenative.devtestlab.kotlin.outputs.GetDiskResult.Companion.toKotlin as getDiskResultToKotlin
import com.pulumi.azurenative.devtestlab.kotlin.outputs.GetEnvironmentResult.Companion.toKotlin as getEnvironmentResultToKotlin
import com.pulumi.azurenative.devtestlab.kotlin.outputs.GetFormulaResult.Companion.toKotlin as getFormulaResultToKotlin
import com.pulumi.azurenative.devtestlab.kotlin.outputs.GetGlobalScheduleResult.Companion.toKotlin as getGlobalScheduleResultToKotlin
import com.pulumi.azurenative.devtestlab.kotlin.outputs.GetLabResult.Companion.toKotlin as getLabResultToKotlin
import com.pulumi.azurenative.devtestlab.kotlin.outputs.GetNotificationChannelResult.Companion.toKotlin as getNotificationChannelResultToKotlin
import com.pulumi.azurenative.devtestlab.kotlin.outputs.GetPolicyResult.Companion.toKotlin as getPolicyResultToKotlin
import com.pulumi.azurenative.devtestlab.kotlin.outputs.GetScheduleResult.Companion.toKotlin as getScheduleResultToKotlin
import com.pulumi.azurenative.devtestlab.kotlin.outputs.GetSecretResult.Companion.toKotlin as getSecretResultToKotlin
import com.pulumi.azurenative.devtestlab.kotlin.outputs.GetServiceFabricResult.Companion.toKotlin as getServiceFabricResultToKotlin
import com.pulumi.azurenative.devtestlab.kotlin.outputs.GetServiceFabricScheduleResult.Companion.toKotlin as getServiceFabricScheduleResultToKotlin
import com.pulumi.azurenative.devtestlab.kotlin.outputs.GetServiceRunnerResult.Companion.toKotlin as getServiceRunnerResultToKotlin
import com.pulumi.azurenative.devtestlab.kotlin.outputs.GetUserResult.Companion.toKotlin as getUserResultToKotlin
import com.pulumi.azurenative.devtestlab.kotlin.outputs.GetVirtualMachineRdpFileContentsResult.Companion.toKotlin as getVirtualMachineRdpFileContentsResultToKotlin
import com.pulumi.azurenative.devtestlab.kotlin.outputs.GetVirtualMachineResult.Companion.toKotlin as getVirtualMachineResultToKotlin
import com.pulumi.azurenative.devtestlab.kotlin.outputs.GetVirtualMachineScheduleResult.Companion.toKotlin as getVirtualMachineScheduleResultToKotlin
import com.pulumi.azurenative.devtestlab.kotlin.outputs.GetVirtualNetworkResult.Companion.toKotlin as getVirtualNetworkResultToKotlin
import com.pulumi.azurenative.devtestlab.kotlin.outputs.ListLabVhdsResult.Companion.toKotlin as listLabVhdsResultToKotlin
import com.pulumi.azurenative.devtestlab.kotlin.outputs.ListScheduleApplicableResult.Companion.toKotlin as listScheduleApplicableResultToKotlin
import com.pulumi.azurenative.devtestlab.kotlin.outputs.ListServiceFabricApplicableSchedulesResult.Companion.toKotlin as listServiceFabricApplicableSchedulesResultToKotlin
import com.pulumi.azurenative.devtestlab.kotlin.outputs.ListVirtualMachineApplicableSchedulesResult.Companion.toKotlin as listVirtualMachineApplicableSchedulesResultToKotlin

public object DevtestlabFunctions {
    /**
     * Get artifact source.
     * Azure REST API version: 2018-09-15.
     * Other available API versions: 2016-05-15.
     * @param argument null
     * @return Properties of an artifact source.
     */
    public suspend fun getArtifactSource(argument: GetArtifactSourcePlainArgs): GetArtifactSourceResult =
        getArtifactSourceResultToKotlin(getArtifactSourcePlain(argument.toJava()).await())

    /**
     * @see [getArtifactSource].
     * @param expand Specify the $expand query. Example: 'properties($select=displayName)'
     * @param labName The name of the lab.
     * @param name The name of the artifact source.
     * @param resourceGroupName The name of the resource group.
     * @return Properties of an artifact source.
     */
    public suspend fun getArtifactSource(
        expand: String? = null,
        labName: String,
        name: String,
        resourceGroupName: String,
    ): GetArtifactSourceResult {
        val argument = GetArtifactSourcePlainArgs(
            expand = expand,
            labName = labName,
            name = name,
            resourceGroupName = resourceGroupName,
        )
        return getArtifactSourceResultToKotlin(getArtifactSourcePlain(argument.toJava()).await())
    }

    /**
     * @see [getArtifactSource].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;devtestlab&#46;kotlin&#46;inputs&#46;GetArtifactSourcePlainArgs].
     * @return Properties of an artifact source.
     */
    public suspend fun getArtifactSource(argument: suspend GetArtifactSourcePlainArgsBuilder.() -> Unit): GetArtifactSourceResult {
        val builder = GetArtifactSourcePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getArtifactSourceResultToKotlin(getArtifactSourcePlain(builtArgument.toJava()).await())
    }

    /**
     * Get custom image.
     * Azure REST API version: 2018-09-15.
     * Other available API versions: 2016-05-15.
     * @param argument null
     * @return A custom image.
     */
    public suspend fun getCustomImage(argument: GetCustomImagePlainArgs): GetCustomImageResult =
        getCustomImageResultToKotlin(getCustomImagePlain(argument.toJava()).await())

    /**
     * @see [getCustomImage].
     * @param expand Specify the $expand query. Example: 'properties($select=vm)'
     * @param labName The name of the lab.
     * @param name The name of the custom image.
     * @param resourceGroupName The name of the resource group.
     * @return A custom image.
     */
    public suspend fun getCustomImage(
        expand: String? = null,
        labName: String,
        name: String,
        resourceGroupName: String,
    ): GetCustomImageResult {
        val argument = GetCustomImagePlainArgs(
            expand = expand,
            labName = labName,
            name = name,
            resourceGroupName = resourceGroupName,
        )
        return getCustomImageResultToKotlin(getCustomImagePlain(argument.toJava()).await())
    }

    /**
     * @see [getCustomImage].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;devtestlab&#46;kotlin&#46;inputs&#46;GetCustomImagePlainArgs].
     * @return A custom image.
     */
    public suspend fun getCustomImage(argument: suspend GetCustomImagePlainArgsBuilder.() -> Unit): GetCustomImageResult {
        val builder = GetCustomImagePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCustomImageResultToKotlin(getCustomImagePlain(builtArgument.toJava()).await())
    }

    /**
     * Get disk.
     * Azure REST API version: 2018-09-15.
     * Other available API versions: 2016-05-15.
     * @param argument null
     * @return A Disk.
     */
    public suspend fun getDisk(argument: GetDiskPlainArgs): GetDiskResult =
        getDiskResultToKotlin(getDiskPlain(argument.toJava()).await())

    /**
     * @see [getDisk].
     * @param expand Specify the $expand query. Example: 'properties($select=diskType)'
     * @param labName The name of the lab.
     * @param name The name of the disk.
     * @param resourceGroupName The name of the resource group.
     * @param userName The name of the user profile.
     * @return A Disk.
     */
    public suspend fun getDisk(
        expand: String? = null,
        labName: String,
        name: String,
        resourceGroupName: String,
        userName: String,
    ): GetDiskResult {
        val argument = GetDiskPlainArgs(
            expand = expand,
            labName = labName,
            name = name,
            resourceGroupName = resourceGroupName,
            userName = userName,
        )
        return getDiskResultToKotlin(getDiskPlain(argument.toJava()).await())
    }

    /**
     * @see [getDisk].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;devtestlab&#46;kotlin&#46;inputs&#46;GetDiskPlainArgs].
     * @return A Disk.
     */
    public suspend fun getDisk(argument: suspend GetDiskPlainArgsBuilder.() -> Unit): GetDiskResult {
        val builder = GetDiskPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDiskResultToKotlin(getDiskPlain(builtArgument.toJava()).await())
    }

    /**
     * Get environment.
     * Azure REST API version: 2018-09-15.
     * Other available API versions: 2016-05-15.
     * @param argument null
     * @return An environment, which is essentially an ARM template deployment.
     */
    public suspend fun getEnvironment(argument: GetEnvironmentPlainArgs): GetEnvironmentResult =
        getEnvironmentResultToKotlin(getEnvironmentPlain(argument.toJava()).await())

    /**
     * @see [getEnvironment].
     * @param expand Specify the $expand query. Example: 'properties($select=deploymentProperties)'
     * @param labName The name of the lab.
     * @param name The name of the environment.
     * @param resourceGroupName The name of the resource group.
     * @param userName The name of the user profile.
     * @return An environment, which is essentially an ARM template deployment.
     */
    public suspend fun getEnvironment(
        expand: String? = null,
        labName: String,
        name: String,
        resourceGroupName: String,
        userName: String,
    ): GetEnvironmentResult {
        val argument = GetEnvironmentPlainArgs(
            expand = expand,
            labName = labName,
            name = name,
            resourceGroupName = resourceGroupName,
            userName = userName,
        )
        return getEnvironmentResultToKotlin(getEnvironmentPlain(argument.toJava()).await())
    }

    /**
     * @see [getEnvironment].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;devtestlab&#46;kotlin&#46;inputs&#46;GetEnvironmentPlainArgs].
     * @return An environment, which is essentially an ARM template deployment.
     */
    public suspend fun getEnvironment(argument: suspend GetEnvironmentPlainArgsBuilder.() -> Unit): GetEnvironmentResult {
        val builder = GetEnvironmentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEnvironmentResultToKotlin(getEnvironmentPlain(builtArgument.toJava()).await())
    }

    /**
     * Get formula.
     * Azure REST API version: 2018-09-15.
     * Other available API versions: 2016-05-15.
     * @param argument null
     * @return A formula for creating a VM, specifying an image base and other parameters
     */
    public suspend fun getFormula(argument: GetFormulaPlainArgs): GetFormulaResult =
        getFormulaResultToKotlin(getFormulaPlain(argument.toJava()).await())

    /**
     * @see [getFormula].
     * @param expand Specify the $expand query. Example: 'properties($select=description)'
     * @param labName The name of the lab.
     * @param name The name of the formula.
     * @param resourceGroupName The name of the resource group.
     * @return A formula for creating a VM, specifying an image base and other parameters
     */
    public suspend fun getFormula(
        expand: String? = null,
        labName: String,
        name: String,
        resourceGroupName: String,
    ): GetFormulaResult {
        val argument = GetFormulaPlainArgs(
            expand = expand,
            labName = labName,
            name = name,
            resourceGroupName = resourceGroupName,
        )
        return getFormulaResultToKotlin(getFormulaPlain(argument.toJava()).await())
    }

    /**
     * @see [getFormula].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;devtestlab&#46;kotlin&#46;inputs&#46;GetFormulaPlainArgs].
     * @return A formula for creating a VM, specifying an image base and other parameters
     */
    public suspend fun getFormula(argument: suspend GetFormulaPlainArgsBuilder.() -> Unit): GetFormulaResult {
        val builder = GetFormulaPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getFormulaResultToKotlin(getFormulaPlain(builtArgument.toJava()).await())
    }

    /**
     * Get schedule.
     * Azure REST API version: 2018-09-15.
     * Other available API versions: 2016-05-15.
     * @param argument null
     * @return A schedule.
     */
    public suspend fun getGlobalSchedule(argument: GetGlobalSchedulePlainArgs): GetGlobalScheduleResult =
        getGlobalScheduleResultToKotlin(getGlobalSchedulePlain(argument.toJava()).await())

    /**
     * @see [getGlobalSchedule].
     * @param expand Specify the $expand query. Example: 'properties($select=status)'
     * @param name The name of the schedule.
     * @param resourceGroupName The name of the resource group.
     * @return A schedule.
     */
    public suspend fun getGlobalSchedule(
        expand: String? = null,
        name: String,
        resourceGroupName: String,
    ): GetGlobalScheduleResult {
        val argument = GetGlobalSchedulePlainArgs(
            expand = expand,
            name = name,
            resourceGroupName = resourceGroupName,
        )
        return getGlobalScheduleResultToKotlin(getGlobalSchedulePlain(argument.toJava()).await())
    }

    /**
     * @see [getGlobalSchedule].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;devtestlab&#46;kotlin&#46;inputs&#46;GetGlobalSchedulePlainArgs].
     * @return A schedule.
     */
    public suspend fun getGlobalSchedule(argument: suspend GetGlobalSchedulePlainArgsBuilder.() -> Unit): GetGlobalScheduleResult {
        val builder = GetGlobalSchedulePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGlobalScheduleResultToKotlin(getGlobalSchedulePlain(builtArgument.toJava()).await())
    }

    /**
     * Get lab.
     * Azure REST API version: 2018-09-15.
     * Other available API versions: 2016-05-15.
     * @param argument null
     * @return A lab.
     */
    public suspend fun getLab(argument: GetLabPlainArgs): GetLabResult =
        getLabResultToKotlin(getLabPlain(argument.toJava()).await())

    /**
     * @see [getLab].
     * @param expand Specify the $expand query. Example: 'properties($select=defaultStorageAccount)'
     * @param name The name of the lab.
     * @param resourceGroupName The name of the resource group.
     * @return A lab.
     */
    public suspend fun getLab(
        expand: String? = null,
        name: String,
        resourceGroupName: String,
    ): GetLabResult {
        val argument = GetLabPlainArgs(
            expand = expand,
            name = name,
            resourceGroupName = resourceGroupName,
        )
        return getLabResultToKotlin(getLabPlain(argument.toJava()).await())
    }

    /**
     * @see [getLab].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;devtestlab&#46;kotlin&#46;inputs&#46;GetLabPlainArgs].
     * @return A lab.
     */
    public suspend fun getLab(argument: suspend GetLabPlainArgsBuilder.() -> Unit): GetLabResult {
        val builder = GetLabPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLabResultToKotlin(getLabPlain(builtArgument.toJava()).await())
    }

    /**
     * Get notification channel.
     * Azure REST API version: 2018-09-15.
     * Other available API versions: 2016-05-15.
     * @param argument null
     * @return A notification.
     */
    public suspend fun getNotificationChannel(argument: GetNotificationChannelPlainArgs): GetNotificationChannelResult =
        getNotificationChannelResultToKotlin(getNotificationChannelPlain(argument.toJava()).await())

    /**
     * @see [getNotificationChannel].
     * @param expand Specify the $expand query. Example: 'properties($select=webHookUrl)'
     * @param labName The name of the lab.
     * @param name The name of the notification channel.
     * @param resourceGroupName The name of the resource group.
     * @return A notification.
     */
    public suspend fun getNotificationChannel(
        expand: String? = null,
        labName: String,
        name: String,
        resourceGroupName: String,
    ): GetNotificationChannelResult {
        val argument = GetNotificationChannelPlainArgs(
            expand = expand,
            labName = labName,
            name = name,
            resourceGroupName = resourceGroupName,
        )
        return getNotificationChannelResultToKotlin(getNotificationChannelPlain(argument.toJava()).await())
    }

    /**
     * @see [getNotificationChannel].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;devtestlab&#46;kotlin&#46;inputs&#46;GetNotificationChannelPlainArgs].
     * @return A notification.
     */
    public suspend fun getNotificationChannel(argument: suspend GetNotificationChannelPlainArgsBuilder.() -> Unit): GetNotificationChannelResult {
        val builder = GetNotificationChannelPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNotificationChannelResultToKotlin(getNotificationChannelPlain(builtArgument.toJava()).await())
    }

    /**
     * Get policy.
     * Azure REST API version: 2018-09-15.
     * Other available API versions: 2016-05-15.
     * @param argument null
     * @return A Policy.
     */
    public suspend fun getPolicy(argument: GetPolicyPlainArgs): GetPolicyResult =
        getPolicyResultToKotlin(getPolicyPlain(argument.toJava()).await())

    /**
     * @see [getPolicy].
     * @param expand Specify the $expand query. Example: 'properties($select=description)'
     * @param labName The name of the lab.
     * @param name The name of the policy.
     * @param policySetName The name of the policy set.
     * @param resourceGroupName The name of the resource group.
     * @return A Policy.
     */
    public suspend fun getPolicy(
        expand: String? = null,
        labName: String,
        name: String,
        policySetName: String,
        resourceGroupName: String,
    ): GetPolicyResult {
        val argument = GetPolicyPlainArgs(
            expand = expand,
            labName = labName,
            name = name,
            policySetName = policySetName,
            resourceGroupName = resourceGroupName,
        )
        return getPolicyResultToKotlin(getPolicyPlain(argument.toJava()).await())
    }

    /**
     * @see [getPolicy].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;devtestlab&#46;kotlin&#46;inputs&#46;GetPolicyPlainArgs].
     * @return A Policy.
     */
    public suspend fun getPolicy(argument: suspend GetPolicyPlainArgsBuilder.() -> Unit): GetPolicyResult {
        val builder = GetPolicyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPolicyResultToKotlin(getPolicyPlain(builtArgument.toJava()).await())
    }

    /**
     * Get schedule.
     * Azure REST API version: 2018-09-15.
     * Other available API versions: 2016-05-15.
     * @param argument null
     * @return A schedule.
     */
    public suspend fun getSchedule(argument: GetSchedulePlainArgs): GetScheduleResult =
        getScheduleResultToKotlin(getSchedulePlain(argument.toJava()).await())

    /**
     * @see [getSchedule].
     * @param expand Specify the $expand query. Example: 'properties($select=status)'
     * @param labName The name of the lab.
     * @param name The name of the schedule.
     * @param resourceGroupName The name of the resource group.
     * @return A schedule.
     */
    public suspend fun getSchedule(
        expand: String? = null,
        labName: String,
        name: String,
        resourceGroupName: String,
    ): GetScheduleResult {
        val argument = GetSchedulePlainArgs(
            expand = expand,
            labName = labName,
            name = name,
            resourceGroupName = resourceGroupName,
        )
        return getScheduleResultToKotlin(getSchedulePlain(argument.toJava()).await())
    }

    /**
     * @see [getSchedule].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;devtestlab&#46;kotlin&#46;inputs&#46;GetSchedulePlainArgs].
     * @return A schedule.
     */
    public suspend fun getSchedule(argument: suspend GetSchedulePlainArgsBuilder.() -> Unit): GetScheduleResult {
        val builder = GetSchedulePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getScheduleResultToKotlin(getSchedulePlain(builtArgument.toJava()).await())
    }

    /**
     * Get secret.
     * Azure REST API version: 2018-09-15.
     * Other available API versions: 2016-05-15.
     * @param argument null
     * @return A secret.
     */
    public suspend fun getSecret(argument: GetSecretPlainArgs): GetSecretResult =
        getSecretResultToKotlin(getSecretPlain(argument.toJava()).await())

    /**
     * @see [getSecret].
     * @param expand Specify the $expand query. Example: 'properties($select=value)'
     * @param labName The name of the lab.
     * @param name The name of the secret.
     * @param resourceGroupName The name of the resource group.
     * @param userName The name of the user profile.
     * @return A secret.
     */
    public suspend fun getSecret(
        expand: String? = null,
        labName: String,
        name: String,
        resourceGroupName: String,
        userName: String,
    ): GetSecretResult {
        val argument = GetSecretPlainArgs(
            expand = expand,
            labName = labName,
            name = name,
            resourceGroupName = resourceGroupName,
            userName = userName,
        )
        return getSecretResultToKotlin(getSecretPlain(argument.toJava()).await())
    }

    /**
     * @see [getSecret].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;devtestlab&#46;kotlin&#46;inputs&#46;GetSecretPlainArgs].
     * @return A secret.
     */
    public suspend fun getSecret(argument: suspend GetSecretPlainArgsBuilder.() -> Unit): GetSecretResult {
        val builder = GetSecretPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSecretResultToKotlin(getSecretPlain(builtArgument.toJava()).await())
    }

    /**
     * Get service fabric.
     * Azure REST API version: 2018-09-15.
     * @param argument null
     * @return A Service Fabric.
     */
    public suspend fun getServiceFabric(argument: GetServiceFabricPlainArgs): GetServiceFabricResult =
        getServiceFabricResultToKotlin(getServiceFabricPlain(argument.toJava()).await())

    /**
     * @see [getServiceFabric].
     * @param expand Specify the $expand query. Example: 'properties($expand=applicableSchedule)'
     * @param labName The name of the lab.
     * @param name The name of the service fabric.
     * @param resourceGroupName The name of the resource group.
     * @param userName The name of the user profile.
     * @return A Service Fabric.
     */
    public suspend fun getServiceFabric(
        expand: String? = null,
        labName: String,
        name: String,
        resourceGroupName: String,
        userName: String,
    ): GetServiceFabricResult {
        val argument = GetServiceFabricPlainArgs(
            expand = expand,
            labName = labName,
            name = name,
            resourceGroupName = resourceGroupName,
            userName = userName,
        )
        return getServiceFabricResultToKotlin(getServiceFabricPlain(argument.toJava()).await())
    }

    /**
     * @see [getServiceFabric].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;devtestlab&#46;kotlin&#46;inputs&#46;GetServiceFabricPlainArgs].
     * @return A Service Fabric.
     */
    public suspend fun getServiceFabric(argument: suspend GetServiceFabricPlainArgsBuilder.() -> Unit): GetServiceFabricResult {
        val builder = GetServiceFabricPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServiceFabricResultToKotlin(getServiceFabricPlain(builtArgument.toJava()).await())
    }

    /**
     * Get schedule.
     * Azure REST API version: 2018-09-15.
     * @param argument null
     * @return A schedule.
     */
    public suspend fun getServiceFabricSchedule(argument: GetServiceFabricSchedulePlainArgs): GetServiceFabricScheduleResult =
        getServiceFabricScheduleResultToKotlin(getServiceFabricSchedulePlain(argument.toJava()).await())

    /**
     * @see [getServiceFabricSchedule].
     * @param expand Specify the $expand query. Example: 'properties($select=status)'
     * @param labName The name of the lab.
     * @param name The name of the schedule.
     * @param resourceGroupName The name of the resource group.
     * @param serviceFabricName The name of the service fabric.
     * @param userName The name of the user profile.
     * @return A schedule.
     */
    public suspend fun getServiceFabricSchedule(
        expand: String? = null,
        labName: String,
        name: String,
        resourceGroupName: String,
        serviceFabricName: String,
        userName: String,
    ): GetServiceFabricScheduleResult {
        val argument = GetServiceFabricSchedulePlainArgs(
            expand = expand,
            labName = labName,
            name = name,
            resourceGroupName = resourceGroupName,
            serviceFabricName = serviceFabricName,
            userName = userName,
        )
        return getServiceFabricScheduleResultToKotlin(getServiceFabricSchedulePlain(argument.toJava()).await())
    }

    /**
     * @see [getServiceFabricSchedule].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;devtestlab&#46;kotlin&#46;inputs&#46;GetServiceFabricSchedulePlainArgs].
     * @return A schedule.
     */
    public suspend fun getServiceFabricSchedule(argument: suspend GetServiceFabricSchedulePlainArgsBuilder.() -> Unit): GetServiceFabricScheduleResult {
        val builder = GetServiceFabricSchedulePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServiceFabricScheduleResultToKotlin(getServiceFabricSchedulePlain(builtArgument.toJava()).await())
    }

    /**
     * Get service runner.
     * Azure REST API version: 2018-09-15.
     * @param argument null
     * @return A container for a managed identity to execute DevTest lab services.
     */
    public suspend fun getServiceRunner(argument: GetServiceRunnerPlainArgs): GetServiceRunnerResult =
        getServiceRunnerResultToKotlin(getServiceRunnerPlain(argument.toJava()).await())

    /**
     * @see [getServiceRunner].
     * @param labName The name of the lab.
     * @param name The name of the service runner.
     * @param resourceGroupName The name of the resource group.
     * @return A container for a managed identity to execute DevTest lab services.
     */
    public suspend fun getServiceRunner(
        labName: String,
        name: String,
        resourceGroupName: String,
    ): GetServiceRunnerResult {
        val argument = GetServiceRunnerPlainArgs(
            labName = labName,
            name = name,
            resourceGroupName = resourceGroupName,
        )
        return getServiceRunnerResultToKotlin(getServiceRunnerPlain(argument.toJava()).await())
    }

    /**
     * @see [getServiceRunner].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;devtestlab&#46;kotlin&#46;inputs&#46;GetServiceRunnerPlainArgs].
     * @return A container for a managed identity to execute DevTest lab services.
     */
    public suspend fun getServiceRunner(argument: suspend GetServiceRunnerPlainArgsBuilder.() -> Unit): GetServiceRunnerResult {
        val builder = GetServiceRunnerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServiceRunnerResultToKotlin(getServiceRunnerPlain(builtArgument.toJava()).await())
    }

    /**
     * Get user profile.
     * Azure REST API version: 2018-09-15.
     * Other available API versions: 2016-05-15.
     * @param argument null
     * @return Profile of a lab user.
     */
    public suspend fun getUser(argument: GetUserPlainArgs): GetUserResult =
        getUserResultToKotlin(getUserPlain(argument.toJava()).await())

    /**
     * @see [getUser].
     * @param expand Specify the $expand query. Example: 'properties($select=identity)'
     * @param labName The name of the lab.
     * @param name The name of the user profile.
     * @param resourceGroupName The name of the resource group.
     * @return Profile of a lab user.
     */
    public suspend fun getUser(
        expand: String? = null,
        labName: String,
        name: String,
        resourceGroupName: String,
    ): GetUserResult {
        val argument = GetUserPlainArgs(
            expand = expand,
            labName = labName,
            name = name,
            resourceGroupName = resourceGroupName,
        )
        return getUserResultToKotlin(getUserPlain(argument.toJava()).await())
    }

    /**
     * @see [getUser].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;devtestlab&#46;kotlin&#46;inputs&#46;GetUserPlainArgs].
     * @return Profile of a lab user.
     */
    public suspend fun getUser(argument: suspend GetUserPlainArgsBuilder.() -> Unit): GetUserResult {
        val builder = GetUserPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getUserResultToKotlin(getUserPlain(builtArgument.toJava()).await())
    }

    /**
     * Get virtual machine.
     * Azure REST API version: 2018-09-15.
     * Other available API versions: 2016-05-15.
     * @param argument null
     * @return A virtual machine.
     */
    public suspend fun getVirtualMachine(argument: GetVirtualMachinePlainArgs): GetVirtualMachineResult =
        getVirtualMachineResultToKotlin(getVirtualMachinePlain(argument.toJava()).await())

    /**
     * @see [getVirtualMachine].
     * @param expand Specify the $expand query. Example: 'properties($expand=artifacts,computeVm,networkInterface,applicableSchedule)'
     * @param labName The name of the lab.
     * @param name The name of the virtual machine.
     * @param resourceGroupName The name of the resource group.
     * @return A virtual machine.
     */
    public suspend fun getVirtualMachine(
        expand: String? = null,
        labName: String,
        name: String,
        resourceGroupName: String,
    ): GetVirtualMachineResult {
        val argument = GetVirtualMachinePlainArgs(
            expand = expand,
            labName = labName,
            name = name,
            resourceGroupName = resourceGroupName,
        )
        return getVirtualMachineResultToKotlin(getVirtualMachinePlain(argument.toJava()).await())
    }

    /**
     * @see [getVirtualMachine].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;devtestlab&#46;kotlin&#46;inputs&#46;GetVirtualMachinePlainArgs].
     * @return A virtual machine.
     */
    public suspend fun getVirtualMachine(argument: suspend GetVirtualMachinePlainArgsBuilder.() -> Unit): GetVirtualMachineResult {
        val builder = GetVirtualMachinePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVirtualMachineResultToKotlin(getVirtualMachinePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a string that represents the contents of the RDP file for the virtual machine
     * Azure REST API version: 2018-09-15.
     * @param argument null
     * @return Represents a .rdp file
     */
    public suspend fun getVirtualMachineRdpFileContents(argument: GetVirtualMachineRdpFileContentsPlainArgs): GetVirtualMachineRdpFileContentsResult =
        getVirtualMachineRdpFileContentsResultToKotlin(getVirtualMachineRdpFileContentsPlain(argument.toJava()).await())

    /**
     * @see [getVirtualMachineRdpFileContents].
     * @param labName The name of the lab.
     * @param name The name of the virtual machine.
     * @param resourceGroupName The name of the resource group.
     * @return Represents a .rdp file
     */
    public suspend fun getVirtualMachineRdpFileContents(
        labName: String,
        name: String,
        resourceGroupName: String,
    ): GetVirtualMachineRdpFileContentsResult {
        val argument = GetVirtualMachineRdpFileContentsPlainArgs(
            labName = labName,
            name = name,
            resourceGroupName = resourceGroupName,
        )
        return getVirtualMachineRdpFileContentsResultToKotlin(getVirtualMachineRdpFileContentsPlain(argument.toJava()).await())
    }

    /**
     * @see [getVirtualMachineRdpFileContents].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;devtestlab&#46;kotlin&#46;inputs&#46;GetVirtualMachineRdpFileContentsPlainArgs].
     * @return Represents a .rdp file
     */
    public suspend fun getVirtualMachineRdpFileContents(argument: suspend GetVirtualMachineRdpFileContentsPlainArgsBuilder.() -> Unit): GetVirtualMachineRdpFileContentsResult {
        val builder = GetVirtualMachineRdpFileContentsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVirtualMachineRdpFileContentsResultToKotlin(getVirtualMachineRdpFileContentsPlain(builtArgument.toJava()).await())
    }

    /**
     * Get schedule.
     * Azure REST API version: 2018-09-15.
     * Other available API versions: 2016-05-15.
     * @param argument null
     * @return A schedule.
     */
    public suspend fun getVirtualMachineSchedule(argument: GetVirtualMachineSchedulePlainArgs): GetVirtualMachineScheduleResult =
        getVirtualMachineScheduleResultToKotlin(getVirtualMachineSchedulePlain(argument.toJava()).await())

    /**
     * @see [getVirtualMachineSchedule].
     * @param expand Specify the $expand query. Example: 'properties($select=status)'
     * @param labName The name of the lab.
     * @param name The name of the schedule.
     * @param resourceGroupName The name of the resource group.
     * @param virtualMachineName The name of the virtual machine.
     * @return A schedule.
     */
    public suspend fun getVirtualMachineSchedule(
        expand: String? = null,
        labName: String,
        name: String,
        resourceGroupName: String,
        virtualMachineName: String,
    ): GetVirtualMachineScheduleResult {
        val argument = GetVirtualMachineSchedulePlainArgs(
            expand = expand,
            labName = labName,
            name = name,
            resourceGroupName = resourceGroupName,
            virtualMachineName = virtualMachineName,
        )
        return getVirtualMachineScheduleResultToKotlin(getVirtualMachineSchedulePlain(argument.toJava()).await())
    }

    /**
     * @see [getVirtualMachineSchedule].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;devtestlab&#46;kotlin&#46;inputs&#46;GetVirtualMachineSchedulePlainArgs].
     * @return A schedule.
     */
    public suspend fun getVirtualMachineSchedule(argument: suspend GetVirtualMachineSchedulePlainArgsBuilder.() -> Unit): GetVirtualMachineScheduleResult {
        val builder = GetVirtualMachineSchedulePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVirtualMachineScheduleResultToKotlin(getVirtualMachineSchedulePlain(builtArgument.toJava()).await())
    }

    /**
     * Get virtual network.
     * Azure REST API version: 2018-09-15.
     * Other available API versions: 2016-05-15.
     * @param argument null
     * @return A virtual network.
     */
    public suspend fun getVirtualNetwork(argument: GetVirtualNetworkPlainArgs): GetVirtualNetworkResult =
        getVirtualNetworkResultToKotlin(getVirtualNetworkPlain(argument.toJava()).await())

    /**
     * @see [getVirtualNetwork].
     * @param expand Specify the $expand query. Example: 'properties($expand=externalSubnets)'
     * @param labName The name of the lab.
     * @param name The name of the virtual network.
     * @param resourceGroupName The name of the resource group.
     * @return A virtual network.
     */
    public suspend fun getVirtualNetwork(
        expand: String? = null,
        labName: String,
        name: String,
        resourceGroupName: String,
    ): GetVirtualNetworkResult {
        val argument = GetVirtualNetworkPlainArgs(
            expand = expand,
            labName = labName,
            name = name,
            resourceGroupName = resourceGroupName,
        )
        return getVirtualNetworkResultToKotlin(getVirtualNetworkPlain(argument.toJava()).await())
    }

    /**
     * @see [getVirtualNetwork].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;devtestlab&#46;kotlin&#46;inputs&#46;GetVirtualNetworkPlainArgs].
     * @return A virtual network.
     */
    public suspend fun getVirtualNetwork(argument: suspend GetVirtualNetworkPlainArgsBuilder.() -> Unit): GetVirtualNetworkResult {
        val builder = GetVirtualNetworkPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVirtualNetworkResultToKotlin(getVirtualNetworkPlain(builtArgument.toJava()).await())
    }

    /**
     * List disk images available for custom image creation.
     * Azure REST API version: 2018-09-15.
     * Other available API versions: 2015-05-21-preview, 2016-05-15.
     * @param argument null
     * @return The response of a list operation.
     */
    public suspend fun listLabVhds(argument: ListLabVhdsPlainArgs): ListLabVhdsResult =
        listLabVhdsResultToKotlin(listLabVhdsPlain(argument.toJava()).await())

    /**
     * @see [listLabVhds].
     * @param name The name of the lab.
     * @param resourceGroupName The name of the resource group.
     * @return The response of a list operation.
     */
    public suspend fun listLabVhds(name: String, resourceGroupName: String): ListLabVhdsResult {
        val argument = ListLabVhdsPlainArgs(
            name = name,
            resourceGroupName = resourceGroupName,
        )
        return listLabVhdsResultToKotlin(listLabVhdsPlain(argument.toJava()).await())
    }

    /**
     * @see [listLabVhds].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;devtestlab&#46;kotlin&#46;inputs&#46;ListLabVhdsPlainArgs].
     * @return The response of a list operation.
     */
    public suspend fun listLabVhds(argument: suspend ListLabVhdsPlainArgsBuilder.() -> Unit): ListLabVhdsResult {
        val builder = ListLabVhdsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listLabVhdsResultToKotlin(listLabVhdsPlain(builtArgument.toJava()).await())
    }

    /**
     * Lists all applicable schedules
     * Azure REST API version: 2018-09-15.
     * Other available API versions: 2016-05-15.
     * @param argument null
     * @return The response of a list operation.
     */
    public suspend fun listScheduleApplicable(argument: ListScheduleApplicablePlainArgs): ListScheduleApplicableResult =
        listScheduleApplicableResultToKotlin(listScheduleApplicablePlain(argument.toJava()).await())

    /**
     * @see [listScheduleApplicable].
     * @param labName The name of the lab.
     * @param name The name of the schedule.
     * @param resourceGroupName The name of the resource group.
     * @return The response of a list operation.
     */
    public suspend fun listScheduleApplicable(
        labName: String,
        name: String,
        resourceGroupName: String,
    ): ListScheduleApplicableResult {
        val argument = ListScheduleApplicablePlainArgs(
            labName = labName,
            name = name,
            resourceGroupName = resourceGroupName,
        )
        return listScheduleApplicableResultToKotlin(listScheduleApplicablePlain(argument.toJava()).await())
    }

    /**
     * @see [listScheduleApplicable].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;devtestlab&#46;kotlin&#46;inputs&#46;ListScheduleApplicablePlainArgs].
     * @return The response of a list operation.
     */
    public suspend fun listScheduleApplicable(argument: suspend ListScheduleApplicablePlainArgsBuilder.() -> Unit): ListScheduleApplicableResult {
        val builder = ListScheduleApplicablePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listScheduleApplicableResultToKotlin(listScheduleApplicablePlain(builtArgument.toJava()).await())
    }

    /**
     * Lists the applicable start/stop schedules, if any.
     * Azure REST API version: 2018-09-15.
     * @param argument null
     * @return Schedules applicable to a virtual machine. The schedules may have been defined on a VM or on lab level.
     */
    public suspend fun listServiceFabricApplicableSchedules(argument: ListServiceFabricApplicableSchedulesPlainArgs): ListServiceFabricApplicableSchedulesResult =
        listServiceFabricApplicableSchedulesResultToKotlin(listServiceFabricApplicableSchedulesPlain(argument.toJava()).await())

    /**
     * @see [listServiceFabricApplicableSchedules].
     * @param labName The name of the lab.
     * @param name The name of the service fabric.
     * @param resourceGroupName The name of the resource group.
     * @param userName The name of the user profile.
     * @return Schedules applicable to a virtual machine. The schedules may have been defined on a VM or on lab level.
     */
    public suspend fun listServiceFabricApplicableSchedules(
        labName: String,
        name: String,
        resourceGroupName: String,
        userName: String,
    ): ListServiceFabricApplicableSchedulesResult {
        val argument = ListServiceFabricApplicableSchedulesPlainArgs(
            labName = labName,
            name = name,
            resourceGroupName = resourceGroupName,
            userName = userName,
        )
        return listServiceFabricApplicableSchedulesResultToKotlin(listServiceFabricApplicableSchedulesPlain(argument.toJava()).await())
    }

    /**
     * @see [listServiceFabricApplicableSchedules].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;devtestlab&#46;kotlin&#46;inputs&#46;ListServiceFabricApplicableSchedulesPlainArgs].
     * @return Schedules applicable to a virtual machine. The schedules may have been defined on a VM or on lab level.
     */
    public suspend fun listServiceFabricApplicableSchedules(argument: suspend ListServiceFabricApplicableSchedulesPlainArgsBuilder.() -> Unit): ListServiceFabricApplicableSchedulesResult {
        val builder = ListServiceFabricApplicableSchedulesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listServiceFabricApplicableSchedulesResultToKotlin(listServiceFabricApplicableSchedulesPlain(builtArgument.toJava()).await())
    }

    /**
     * Lists the applicable start/stop schedules, if any.
     * Azure REST API version: 2018-09-15.
     * Other available API versions: 2016-05-15.
     * @param argument null
     * @return Schedules applicable to a virtual machine. The schedules may have been defined on a VM or on lab level.
     */
    public suspend fun listVirtualMachineApplicableSchedules(argument: ListVirtualMachineApplicableSchedulesPlainArgs): ListVirtualMachineApplicableSchedulesResult =
        listVirtualMachineApplicableSchedulesResultToKotlin(listVirtualMachineApplicableSchedulesPlain(argument.toJava()).await())

    /**
     * @see [listVirtualMachineApplicableSchedules].
     * @param labName The name of the lab.
     * @param name The name of the virtual machine.
     * @param resourceGroupName The name of the resource group.
     * @return Schedules applicable to a virtual machine. The schedules may have been defined on a VM or on lab level.
     */
    public suspend fun listVirtualMachineApplicableSchedules(
        labName: String,
        name: String,
        resourceGroupName: String,
    ): ListVirtualMachineApplicableSchedulesResult {
        val argument = ListVirtualMachineApplicableSchedulesPlainArgs(
            labName = labName,
            name = name,
            resourceGroupName = resourceGroupName,
        )
        return listVirtualMachineApplicableSchedulesResultToKotlin(listVirtualMachineApplicableSchedulesPlain(argument.toJava()).await())
    }

    /**
     * @see [listVirtualMachineApplicableSchedules].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;devtestlab&#46;kotlin&#46;inputs&#46;ListVirtualMachineApplicableSchedulesPlainArgs].
     * @return Schedules applicable to a virtual machine. The schedules may have been defined on a VM or on lab level.
     */
    public suspend fun listVirtualMachineApplicableSchedules(argument: suspend ListVirtualMachineApplicableSchedulesPlainArgsBuilder.() -> Unit): ListVirtualMachineApplicableSchedulesResult {
        val builder = ListVirtualMachineApplicableSchedulesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listVirtualMachineApplicableSchedulesResultToKotlin(listVirtualMachineApplicableSchedulesPlain(builtArgument.toJava()).await())
    }
}
