@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin

import com.pulumi.azurenative.devtestlab.EnvironmentArgs.builder
import com.pulumi.azurenative.devtestlab.kotlin.inputs.EnvironmentDeploymentPropertiesArgs
import com.pulumi.azurenative.devtestlab.kotlin.inputs.EnvironmentDeploymentPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * An environment, which is essentially an ARM template deployment.
 * Azure REST API version: 2018-09-15. Prior API version in Azure Native 1.x: 2018-09-15.
 * Other available API versions: 2016-05-15.
 * ## Example Usage
 * ### Environments_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var environment = new AzureNative.DevTestLab.Environment("environment", new()
 *     {
 *         DeploymentProperties = new AzureNative.DevTestLab.Inputs.EnvironmentDeploymentPropertiesArgs
 *         {
 *             ArmTemplateId = "/subscriptions/{subscriptionId}/resourceGroups/resourceGroupName/providers/Microsoft.DevTestLab/labs/{labName}/artifactSources/{artifactSourceName}/armTemplates/{armTemplateName}",
 *             Parameters = new() { },
 *         },
 *         LabName = "{labName}",
 *         Name = "{environmentName}",
 *         ResourceGroupName = "resourceGroupName",
 *         UserName = "@me",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/devtestlab/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devtestlab.NewEnvironment(ctx, "environment", &devtestlab.EnvironmentArgs{
 * 			DeploymentProperties: &devtestlab.EnvironmentDeploymentPropertiesArgs{
 * 				ArmTemplateId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/resourceGroupName/providers/Microsoft.DevTestLab/labs/{labName}/artifactSources/{artifactSourceName}/armTemplates/{armTemplateName}"),
 * 				Parameters:    devtestlab.ArmTemplateParameterPropertiesArray{},
 * 			},
 * 			LabName:           pulumi.String("{labName}"),
 * 			Name:              pulumi.String("{environmentName}"),
 * 			ResourceGroupName: pulumi.String("resourceGroupName"),
 * 			UserName:          pulumi.String("@me"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.devtestlab.Environment;
 * import com.pulumi.azurenative.devtestlab.EnvironmentArgs;
 * import com.pulumi.azurenative.devtestlab.inputs.EnvironmentDeploymentPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var environment = new Environment("environment", EnvironmentArgs.builder()
 *             .deploymentProperties(EnvironmentDeploymentPropertiesArgs.builder()
 *                 .armTemplateId("/subscriptions/{subscriptionId}/resourceGroups/resourceGroupName/providers/Microsoft.DevTestLab/labs/{labName}/artifactSources/{artifactSourceName}/armTemplates/{armTemplateName}")
 *                 .parameters()
 *                 .build())
 *             .labName("{labName}")
 *             .name("{environmentName}")
 *             .resourceGroupName("resourceGroupName")
 *             .userName("@me")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:devtestlab:Environment {environmentName} /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/users/{userName}/environments/{name}
 * ```
 * @property armTemplateDisplayName The display name of the Azure Resource Manager template that produced the environment.
 * @property deploymentProperties The deployment properties of the environment.
 * @property labName The name of the lab.
 * @property location The location of the resource.
 * @property name The name of the environment.
 * @property resourceGroupName The name of the resource group.
 * @property tags The tags of the resource.
 * @property userName The name of the user profile.
 */
public data class EnvironmentArgs(
    public val armTemplateDisplayName: Output<String>? = null,
    public val deploymentProperties: Output<EnvironmentDeploymentPropertiesArgs>? = null,
    public val labName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val userName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devtestlab.EnvironmentArgs> {
    override fun toJava(): com.pulumi.azurenative.devtestlab.EnvironmentArgs =
        com.pulumi.azurenative.devtestlab.EnvironmentArgs.builder()
            .armTemplateDisplayName(armTemplateDisplayName?.applyValue({ args0 -> args0 }))
            .deploymentProperties(
                deploymentProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .labName(labName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .userName(userName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EnvironmentArgs].
 */
@PulumiTagMarker
public class EnvironmentArgsBuilder internal constructor() {
    private var armTemplateDisplayName: Output<String>? = null

    private var deploymentProperties: Output<EnvironmentDeploymentPropertiesArgs>? = null

    private var labName: Output<String>? = null

    private var location: Output<String>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var userName: Output<String>? = null

    /**
     * @param value The display name of the Azure Resource Manager template that produced the environment.
     */
    @JvmName("gavpkqkhuxamdxiu")
    public suspend fun armTemplateDisplayName(`value`: Output<String>) {
        this.armTemplateDisplayName = value
    }

    /**
     * @param value The deployment properties of the environment.
     */
    @JvmName("olmhumgoqdwycwxn")
    public suspend fun deploymentProperties(`value`: Output<EnvironmentDeploymentPropertiesArgs>) {
        this.deploymentProperties = value
    }

    /**
     * @param value The name of the lab.
     */
    @JvmName("eteqbkoahdspnkhx")
    public suspend fun labName(`value`: Output<String>) {
        this.labName = value
    }

    /**
     * @param value The location of the resource.
     */
    @JvmName("ftotxoqkrbdbuyeu")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the environment.
     */
    @JvmName("fopykjucxqcujeus")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("uqllvltgurgoxvlt")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The tags of the resource.
     */
    @JvmName("dvmirxukkcncyjlc")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the user profile.
     */
    @JvmName("rhmkhytsguotadpc")
    public suspend fun userName(`value`: Output<String>) {
        this.userName = value
    }

    /**
     * @param value The display name of the Azure Resource Manager template that produced the environment.
     */
    @JvmName("iqtixrccpmmbedqd")
    public suspend fun armTemplateDisplayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.armTemplateDisplayName = mapped
    }

    /**
     * @param value The deployment properties of the environment.
     */
    @JvmName("btumwkvvdnqquhlg")
    public suspend fun deploymentProperties(`value`: EnvironmentDeploymentPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploymentProperties = mapped
    }

    /**
     * @param argument The deployment properties of the environment.
     */
    @JvmName("vwdgfyskyqlbehou")
    public suspend fun deploymentProperties(argument: suspend EnvironmentDeploymentPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = EnvironmentDeploymentPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.deploymentProperties = mapped
    }

    /**
     * @param value The name of the lab.
     */
    @JvmName("juscaabcpgjyiwij")
    public suspend fun labName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labName = mapped
    }

    /**
     * @param value The location of the resource.
     */
    @JvmName("nifaprqjhmfgbkca")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the environment.
     */
    @JvmName("brvijppgrmnoknuj")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("xhemgfednwvbpacp")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The tags of the resource.
     */
    @JvmName("ruttwyfgoxviqhvq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tags of the resource.
     */
    @JvmName("bgqrbkagetjpefrs")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The name of the user profile.
     */
    @JvmName("pjyfxrquyuknbihf")
    public suspend fun userName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userName = mapped
    }

    internal fun build(): EnvironmentArgs = EnvironmentArgs(
        armTemplateDisplayName = armTemplateDisplayName,
        deploymentProperties = deploymentProperties,
        labName = labName,
        location = location,
        name = name,
        resourceGroupName = resourceGroupName,
        tags = tags,
        userName = userName,
    )
}
