@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin

import com.pulumi.azurenative.devtestlab.LabArgs.builder
import com.pulumi.azurenative.devtestlab.kotlin.enums.EnvironmentPermission
import com.pulumi.azurenative.devtestlab.kotlin.enums.PremiumDataDisk
import com.pulumi.azurenative.devtestlab.kotlin.enums.StorageType
import com.pulumi.azurenative.devtestlab.kotlin.inputs.LabAnnouncementPropertiesArgs
import com.pulumi.azurenative.devtestlab.kotlin.inputs.LabAnnouncementPropertiesArgsBuilder
import com.pulumi.azurenative.devtestlab.kotlin.inputs.LabSupportPropertiesArgs
import com.pulumi.azurenative.devtestlab.kotlin.inputs.LabSupportPropertiesArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A lab.
 * Azure REST API version: 2018-09-15. Prior API version in Azure Native 1.x: 2018-09-15.
 * Other available API versions: 2016-05-15.
 * ## Example Usage
 * ### Labs_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var lab = new AzureNative.DevTestLab.Lab("lab", new()
 *     {
 *         LabStorageType = "{Standard|Premium}",
 *         Location = "{location}",
 *         Name = "{labName}",
 *         ResourceGroupName = "resourceGroupName",
 *         Tags =
 *         {
 *             { "tagName1", "tagValue1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/devtestlab/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devtestlab.NewLab(ctx, "lab", &devtestlab.LabArgs{
 * 			LabStorageType:    pulumi.String("{Standard|Premium}"),
 * 			Location:          pulumi.String("{location}"),
 * 			Name:              pulumi.String("{labName}"),
 * 			ResourceGroupName: pulumi.String("resourceGroupName"),
 * 			Tags: pulumi.StringMap{
 * 				"tagName1": pulumi.String("tagValue1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.devtestlab.Lab;
 * import com.pulumi.azurenative.devtestlab.LabArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var lab = new Lab("lab", LabArgs.builder()
 *             .labStorageType("{Standard|Premium}")
 *             .location("{location}")
 *             .name("{labName}")
 *             .resourceGroupName("resourceGroupName")
 *             .tags(Map.of("tagName1", "tagValue1"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:devtestlab:Lab {labName} /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{name}
 * ```
 * @property announcement The properties of any lab announcement associated with this lab
 * @property environmentPermission The access rights to be granted to the user when provisioning an environment
 * @property extendedProperties Extended properties of the lab used for experimental features
 * @property labStorageType Type of storage used by the lab. It can be either Premium or Standard. Default is Premium.
 * @property location The location of the resource.
 * @property mandatoryArtifactsResourceIdsLinux The ordered list of artifact resource IDs that should be applied on all Linux VM creations by default, prior to the artifacts specified by the user.
 * @property mandatoryArtifactsResourceIdsWindows The ordered list of artifact resource IDs that should be applied on all Windows VM creations by default, prior to the artifacts specified by the user.
 * @property name The name of the lab.
 * @property premiumDataDisks The setting to enable usage of premium data disks.
 * When its value is 'Enabled', creation of standard or premium data disks is allowed.
 * When its value is 'Disabled', only creation of standard data disks is allowed.
 * @property resourceGroupName The name of the resource group.
 * @property support The properties of any lab support message associated with this lab
 * @property tags The tags of the resource.
 */
public data class LabArgs(
    public val announcement: Output<LabAnnouncementPropertiesArgs>? = null,
    public val environmentPermission: Output<Either<String, EnvironmentPermission>>? = null,
    public val extendedProperties: Output<Map<String, String>>? = null,
    public val labStorageType: Output<Either<String, StorageType>>? = null,
    public val location: Output<String>? = null,
    public val mandatoryArtifactsResourceIdsLinux: Output<List<String>>? = null,
    public val mandatoryArtifactsResourceIdsWindows: Output<List<String>>? = null,
    public val name: Output<String>? = null,
    public val premiumDataDisks: Output<Either<String, PremiumDataDisk>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val support: Output<LabSupportPropertiesArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devtestlab.LabArgs> {
    override fun toJava(): com.pulumi.azurenative.devtestlab.LabArgs =
        com.pulumi.azurenative.devtestlab.LabArgs.builder()
            .announcement(announcement?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .environmentPermission(
                environmentPermission?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .extendedProperties(
                extendedProperties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .labStorageType(
                labStorageType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .mandatoryArtifactsResourceIdsLinux(
                mandatoryArtifactsResourceIdsLinux?.applyValue({ args0 ->
                    args0.map({ args0 -> args0 })
                }),
            )
            .mandatoryArtifactsResourceIdsWindows(
                mandatoryArtifactsResourceIdsWindows?.applyValue({ args0 ->
                    args0.map({ args0 -> args0 })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .premiumDataDisks(
                premiumDataDisks?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .support(support?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [LabArgs].
 */
@PulumiTagMarker
public class LabArgsBuilder internal constructor() {
    private var announcement: Output<LabAnnouncementPropertiesArgs>? = null

    private var environmentPermission: Output<Either<String, EnvironmentPermission>>? = null

    private var extendedProperties: Output<Map<String, String>>? = null

    private var labStorageType: Output<Either<String, StorageType>>? = null

    private var location: Output<String>? = null

    private var mandatoryArtifactsResourceIdsLinux: Output<List<String>>? = null

    private var mandatoryArtifactsResourceIdsWindows: Output<List<String>>? = null

    private var name: Output<String>? = null

    private var premiumDataDisks: Output<Either<String, PremiumDataDisk>>? = null

    private var resourceGroupName: Output<String>? = null

    private var support: Output<LabSupportPropertiesArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The properties of any lab announcement associated with this lab
     */
    @JvmName("cwmiqysrdrpucdkc")
    public suspend fun announcement(`value`: Output<LabAnnouncementPropertiesArgs>) {
        this.announcement = value
    }

    /**
     * @param value The access rights to be granted to the user when provisioning an environment
     */
    @JvmName("awcjsvxtrayywsbv")
    public suspend fun environmentPermission(`value`: Output<Either<String, EnvironmentPermission>>) {
        this.environmentPermission = value
    }

    /**
     * @param value Extended properties of the lab used for experimental features
     */
    @JvmName("wbtvhqyhobbdtwkq")
    public suspend fun extendedProperties(`value`: Output<Map<String, String>>) {
        this.extendedProperties = value
    }

    /**
     * @param value Type of storage used by the lab. It can be either Premium or Standard. Default is Premium.
     */
    @JvmName("cdgrflpkaxljreyl")
    public suspend fun labStorageType(`value`: Output<Either<String, StorageType>>) {
        this.labStorageType = value
    }

    /**
     * @param value The location of the resource.
     */
    @JvmName("oiqiioruswjvfbqo")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The ordered list of artifact resource IDs that should be applied on all Linux VM creations by default, prior to the artifacts specified by the user.
     */
    @JvmName("qlhakjvimiunxnyb")
    public suspend fun mandatoryArtifactsResourceIdsLinux(`value`: Output<List<String>>) {
        this.mandatoryArtifactsResourceIdsLinux = value
    }

    @JvmName("pbygqgdpmvtsogil")
    public suspend fun mandatoryArtifactsResourceIdsLinux(vararg values: Output<String>) {
        this.mandatoryArtifactsResourceIdsLinux = Output.all(values.asList())
    }

    /**
     * @param values The ordered list of artifact resource IDs that should be applied on all Linux VM creations by default, prior to the artifacts specified by the user.
     */
    @JvmName("yvvfpqlvxeojujny")
    public suspend fun mandatoryArtifactsResourceIdsLinux(values: List<Output<String>>) {
        this.mandatoryArtifactsResourceIdsLinux = Output.all(values)
    }

    /**
     * @param value The ordered list of artifact resource IDs that should be applied on all Windows VM creations by default, prior to the artifacts specified by the user.
     */
    @JvmName("pttxfgdcuvowhfyg")
    public suspend fun mandatoryArtifactsResourceIdsWindows(`value`: Output<List<String>>) {
        this.mandatoryArtifactsResourceIdsWindows = value
    }

    @JvmName("tdmajylcdnhlirxc")
    public suspend fun mandatoryArtifactsResourceIdsWindows(vararg values: Output<String>) {
        this.mandatoryArtifactsResourceIdsWindows = Output.all(values.asList())
    }

    /**
     * @param values The ordered list of artifact resource IDs that should be applied on all Windows VM creations by default, prior to the artifacts specified by the user.
     */
    @JvmName("dgfnyerucrwpbjff")
    public suspend fun mandatoryArtifactsResourceIdsWindows(values: List<Output<String>>) {
        this.mandatoryArtifactsResourceIdsWindows = Output.all(values)
    }

    /**
     * @param value The name of the lab.
     */
    @JvmName("gewtcpmmwwyrijdk")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The setting to enable usage of premium data disks.
     * When its value is 'Enabled', creation of standard or premium data disks is allowed.
     * When its value is 'Disabled', only creation of standard data disks is allowed.
     */
    @JvmName("qwrwjnpnevaipbox")
    public suspend fun premiumDataDisks(`value`: Output<Either<String, PremiumDataDisk>>) {
        this.premiumDataDisks = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("nqprqgmqcjmrgpva")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The properties of any lab support message associated with this lab
     */
    @JvmName("babryeiqworanrai")
    public suspend fun support(`value`: Output<LabSupportPropertiesArgs>) {
        this.support = value
    }

    /**
     * @param value The tags of the resource.
     */
    @JvmName("uvkpvwjayvwunvyo")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The properties of any lab announcement associated with this lab
     */
    @JvmName("sggbfspglqdjkvmg")
    public suspend fun announcement(`value`: LabAnnouncementPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.announcement = mapped
    }

    /**
     * @param argument The properties of any lab announcement associated with this lab
     */
    @JvmName("eedhkdhwjsledxyu")
    public suspend fun announcement(argument: suspend LabAnnouncementPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = LabAnnouncementPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.announcement = mapped
    }

    /**
     * @param value The access rights to be granted to the user when provisioning an environment
     */
    @JvmName("injcwtamaugabgqj")
    public suspend fun environmentPermission(`value`: Either<String, EnvironmentPermission>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentPermission = mapped
    }

    /**
     * @param value The access rights to be granted to the user when provisioning an environment
     */
    @JvmName("eugyppvsibaalyfn")
    public fun environmentPermission(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EnvironmentPermission>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.environmentPermission = mapped
    }

    /**
     * @param value The access rights to be granted to the user when provisioning an environment
     */
    @JvmName("ohbhrvmqjdddvyyn")
    public fun environmentPermission(`value`: EnvironmentPermission) {
        val toBeMapped = Either.ofRight<String, EnvironmentPermission>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.environmentPermission = mapped
    }

    /**
     * @param value Extended properties of the lab used for experimental features
     */
    @JvmName("lquiltswteuvotqg")
    public suspend fun extendedProperties(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedProperties = mapped
    }

    /**
     * @param values Extended properties of the lab used for experimental features
     */
    @JvmName("bflawmtkjbtjgsbb")
    public fun extendedProperties(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.extendedProperties = mapped
    }

    /**
     * @param value Type of storage used by the lab. It can be either Premium or Standard. Default is Premium.
     */
    @JvmName("avhuhafeiwrxffyo")
    public suspend fun labStorageType(`value`: Either<String, StorageType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labStorageType = mapped
    }

    /**
     * @param value Type of storage used by the lab. It can be either Premium or Standard. Default is Premium.
     */
    @JvmName("anubjmscbockxytb")
    public fun labStorageType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, StorageType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.labStorageType = mapped
    }

    /**
     * @param value Type of storage used by the lab. It can be either Premium or Standard. Default is Premium.
     */
    @JvmName("muidecytglyuwovh")
    public fun labStorageType(`value`: StorageType) {
        val toBeMapped = Either.ofRight<String, StorageType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.labStorageType = mapped
    }

    /**
     * @param value The location of the resource.
     */
    @JvmName("gvfrfaoioxgigvyr")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The ordered list of artifact resource IDs that should be applied on all Linux VM creations by default, prior to the artifacts specified by the user.
     */
    @JvmName("pmdtfbxcsisfkclk")
    public suspend fun mandatoryArtifactsResourceIdsLinux(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mandatoryArtifactsResourceIdsLinux = mapped
    }

    /**
     * @param values The ordered list of artifact resource IDs that should be applied on all Linux VM creations by default, prior to the artifacts specified by the user.
     */
    @JvmName("cuegmonhphuxqotu")
    public suspend fun mandatoryArtifactsResourceIdsLinux(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mandatoryArtifactsResourceIdsLinux = mapped
    }

    /**
     * @param value The ordered list of artifact resource IDs that should be applied on all Windows VM creations by default, prior to the artifacts specified by the user.
     */
    @JvmName("wjqfeuwlpjayhwra")
    public suspend fun mandatoryArtifactsResourceIdsWindows(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mandatoryArtifactsResourceIdsWindows = mapped
    }

    /**
     * @param values The ordered list of artifact resource IDs that should be applied on all Windows VM creations by default, prior to the artifacts specified by the user.
     */
    @JvmName("albfyvlrphjnmduc")
    public suspend fun mandatoryArtifactsResourceIdsWindows(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mandatoryArtifactsResourceIdsWindows = mapped
    }

    /**
     * @param value The name of the lab.
     */
    @JvmName("hdhdcfjtehasjhxd")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The setting to enable usage of premium data disks.
     * When its value is 'Enabled', creation of standard or premium data disks is allowed.
     * When its value is 'Disabled', only creation of standard data disks is allowed.
     */
    @JvmName("pgmwevutygdiagdf")
    public suspend fun premiumDataDisks(`value`: Either<String, PremiumDataDisk>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.premiumDataDisks = mapped
    }

    /**
     * @param value The setting to enable usage of premium data disks.
     * When its value is 'Enabled', creation of standard or premium data disks is allowed.
     * When its value is 'Disabled', only creation of standard data disks is allowed.
     */
    @JvmName("xntusyaykeumiwvt")
    public fun premiumDataDisks(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PremiumDataDisk>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.premiumDataDisks = mapped
    }

    /**
     * @param value The setting to enable usage of premium data disks.
     * When its value is 'Enabled', creation of standard or premium data disks is allowed.
     * When its value is 'Disabled', only creation of standard data disks is allowed.
     */
    @JvmName("wvfsquvoujwemmdb")
    public fun premiumDataDisks(`value`: PremiumDataDisk) {
        val toBeMapped = Either.ofRight<String, PremiumDataDisk>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.premiumDataDisks = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("devowkcnhwqstwmp")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The properties of any lab support message associated with this lab
     */
    @JvmName("lhmxfvqtknfermat")
    public suspend fun support(`value`: LabSupportPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.support = mapped
    }

    /**
     * @param argument The properties of any lab support message associated with this lab
     */
    @JvmName("jnhkflksopepbrpl")
    public suspend fun support(argument: suspend LabSupportPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = LabSupportPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.support = mapped
    }

    /**
     * @param value The tags of the resource.
     */
    @JvmName("dmuqkxtriwlmifsu")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tags of the resource.
     */
    @JvmName("wmugdiyrowyfkhvr")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): LabArgs = LabArgs(
        announcement = announcement,
        environmentPermission = environmentPermission,
        extendedProperties = extendedProperties,
        labStorageType = labStorageType,
        location = location,
        mandatoryArtifactsResourceIdsLinux = mandatoryArtifactsResourceIdsLinux,
        mandatoryArtifactsResourceIdsWindows = mandatoryArtifactsResourceIdsWindows,
        name = name,
        premiumDataDisks = premiumDataDisks,
        resourceGroupName = resourceGroupName,
        support = support,
        tags = tags,
    )
}
