@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin

import com.pulumi.azurenative.devtestlab.kotlin.outputs.IdentityPropertiesResponse
import com.pulumi.azurenative.devtestlab.kotlin.outputs.IdentityPropertiesResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [ServiceRunner].
 */
@PulumiTagMarker
public class ServiceRunnerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServiceRunnerArgs = ServiceRunnerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServiceRunnerArgsBuilder.() -> Unit) {
        val builder = ServiceRunnerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ServiceRunner {
        val builtJavaResource = com.pulumi.azurenative.devtestlab.ServiceRunner(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ServiceRunner(builtJavaResource)
    }
}

/**
 * A container for a managed identity to execute DevTest lab services.
 * Azure REST API version: 2018-09-15. Prior API version in Azure Native 1.x: 2018-09-15.
 * ## Example Usage
 * ### ServiceRunners_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var serviceRunner = new AzureNative.DevTestLab.ServiceRunner("serviceRunner", new()
 *     {
 *         Identity = new AzureNative.DevTestLab.Inputs.IdentityPropertiesArgs
 *         {
 *             ClientSecretUrl = "{identityClientSecretUrl}",
 *             PrincipalId = "{identityPrincipalId}",
 *             TenantId = "{identityTenantId}",
 *             Type = "{identityType}",
 *         },
 *         LabName = "{devtestlabName}",
 *         Location = "{location}",
 *         Name = "{servicerunnerName}",
 *         ResourceGroupName = "resourceGroupName",
 *         Tags =
 *         {
 *             { "tagName1", "tagValue1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/devtestlab/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devtestlab.NewServiceRunner(ctx, "serviceRunner", &devtestlab.ServiceRunnerArgs{
 * 			Identity: &devtestlab.IdentityPropertiesArgs{
 * 				ClientSecretUrl: pulumi.String("{identityClientSecretUrl}"),
 * 				PrincipalId:     pulumi.String("{identityPrincipalId}"),
 * 				TenantId:        pulumi.String("{identityTenantId}"),
 * 				Type:            pulumi.String("{identityType}"),
 * 			},
 * 			LabName:           pulumi.String("{devtestlabName}"),
 * 			Location:          pulumi.String("{location}"),
 * 			Name:              pulumi.String("{servicerunnerName}"),
 * 			ResourceGroupName: pulumi.String("resourceGroupName"),
 * 			Tags: pulumi.StringMap{
 * 				"tagName1": pulumi.String("tagValue1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.devtestlab.ServiceRunner;
 * import com.pulumi.azurenative.devtestlab.ServiceRunnerArgs;
 * import com.pulumi.azurenative.devtestlab.inputs.IdentityPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var serviceRunner = new ServiceRunner("serviceRunner", ServiceRunnerArgs.builder()
 *             .identity(IdentityPropertiesArgs.builder()
 *                 .clientSecretUrl("{identityClientSecretUrl}")
 *                 .principalId("{identityPrincipalId}")
 *                 .tenantId("{identityTenantId}")
 *                 .type("{identityType}")
 *                 .build())
 *             .labName("{devtestlabName}")
 *             .location("{location}")
 *             .name("{servicerunnerName}")
 *             .resourceGroupName("resourceGroupName")
 *             .tags(Map.of("tagName1", "tagValue1"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:devtestlab:ServiceRunner {serviceRunnerName} /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/servicerunners/{name}
 * ```
 */
public class ServiceRunner internal constructor(
    override val javaResource: com.pulumi.azurenative.devtestlab.ServiceRunner,
) : KotlinCustomResource(javaResource, ServiceRunnerMapper) {
    /**
     * The identity of the resource.
     */
    public val identity: Output<IdentityPropertiesResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The location of the resource.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The tags of the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ServiceRunnerMapper : ResourceMapper<ServiceRunner> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.devtestlab.ServiceRunner::class == javaResource::class

    override fun map(javaResource: Resource): ServiceRunner = ServiceRunner(
        javaResource as
            com.pulumi.azurenative.devtestlab.ServiceRunner,
    )
}

/**
 * @see [ServiceRunner].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ServiceRunner].
 */
public suspend fun serviceRunner(
    name: String,
    block: suspend ServiceRunnerResourceBuilder.() -> Unit,
): ServiceRunner {
    val builder = ServiceRunnerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ServiceRunner].
 * @param name The _unique_ name of the resulting resource.
 */
public fun serviceRunner(name: String): ServiceRunner {
    val builder = ServiceRunnerResourceBuilder()
    builder.name(name)
    return builder.build()
}
