@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin

import com.pulumi.azurenative.devtestlab.kotlin.outputs.UserIdentityResponse
import com.pulumi.azurenative.devtestlab.kotlin.outputs.UserSecretStoreResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.devtestlab.kotlin.outputs.UserIdentityResponse.Companion.toKotlin as userIdentityResponseToKotlin
import com.pulumi.azurenative.devtestlab.kotlin.outputs.UserSecretStoreResponse.Companion.toKotlin as userSecretStoreResponseToKotlin

/**
 * Builder for [User].
 */
@PulumiTagMarker
public class UserResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: UserArgs = UserArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend UserArgsBuilder.() -> Unit) {
        val builder = UserArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): User {
        val builtJavaResource = com.pulumi.azurenative.devtestlab.User(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return User(builtJavaResource)
    }
}

/**
 * Profile of a lab user.
 * Azure REST API version: 2018-09-15. Prior API version in Azure Native 1.x: 2018-09-15.
 * Other available API versions: 2016-05-15.
 * ## Example Usage
 * ### Users_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var user = new AzureNative.DevTestLab.User("user", new()
 *     {
 *         Identity = new AzureNative.DevTestLab.Inputs.UserIdentityArgs
 *         {
 *             AppId = "{appId}",
 *             ObjectId = "{objectId}",
 *             PrincipalId = "{principalId}",
 *             PrincipalName = "{principalName}",
 *             TenantId = "{tenantId}",
 *         },
 *         LabName = "{devtestlabName}",
 *         Location = "{location}",
 *         Name = "{userName}",
 *         ResourceGroupName = "resourceGroupName",
 *         SecretStore = new AzureNative.DevTestLab.Inputs.UserSecretStoreArgs
 *         {
 *             KeyVaultId = "{keyVaultId}",
 *             KeyVaultUri = "{keyVaultUri}",
 *         },
 *         Tags =
 *         {
 *             { "tagName1", "tagValue1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/devtestlab/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devtestlab.NewUser(ctx, "user", &devtestlab.UserArgs{
 * 			Identity: &devtestlab.UserIdentityArgs{
 * 				AppId:         pulumi.String("{appId}"),
 * 				ObjectId:      pulumi.String("{objectId}"),
 * 				PrincipalId:   pulumi.String("{principalId}"),
 * 				PrincipalName: pulumi.String("{principalName}"),
 * 				TenantId:      pulumi.String("{tenantId}"),
 * 			},
 * 			LabName:           pulumi.String("{devtestlabName}"),
 * 			Location:          pulumi.String("{location}"),
 * 			Name:              pulumi.String("{userName}"),
 * 			ResourceGroupName: pulumi.String("resourceGroupName"),
 * 			SecretStore: &devtestlab.UserSecretStoreArgs{
 * 				KeyVaultId:  pulumi.String("{keyVaultId}"),
 * 				KeyVaultUri: pulumi.String("{keyVaultUri}"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"tagName1": pulumi.String("tagValue1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.devtestlab.User;
 * import com.pulumi.azurenative.devtestlab.UserArgs;
 * import com.pulumi.azurenative.devtestlab.inputs.UserIdentityArgs;
 * import com.pulumi.azurenative.devtestlab.inputs.UserSecretStoreArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var user = new User("user", UserArgs.builder()
 *             .identity(UserIdentityArgs.builder()
 *                 .appId("{appId}")
 *                 .objectId("{objectId}")
 *                 .principalId("{principalId}")
 *                 .principalName("{principalName}")
 *                 .tenantId("{tenantId}")
 *                 .build())
 *             .labName("{devtestlabName}")
 *             .location("{location}")
 *             .name("{userName}")
 *             .resourceGroupName("resourceGroupName")
 *             .secretStore(UserSecretStoreArgs.builder()
 *                 .keyVaultId("{keyVaultId}")
 *                 .keyVaultUri("{keyVaultUri}")
 *                 .build())
 *             .tags(Map.of("tagName1", "tagValue1"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:devtestlab:User {userName} /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/users/{name}
 * ```
 */
public class User internal constructor(
    override val javaResource: com.pulumi.azurenative.devtestlab.User,
) : KotlinCustomResource(javaResource, UserMapper) {
    /**
     * The creation date of the user profile.
     */
    public val createdDate: Output<String>
        get() = javaResource.createdDate().applyValue({ args0 -> args0 })

    /**
     * The identity of the user.
     */
    public val identity: Output<UserIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    userIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The location of the resource.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning status of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The secret store of the user.
     */
    public val secretStore: Output<UserSecretStoreResponse>?
        get() = javaResource.secretStore().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    userSecretStoreResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The tags of the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The unique immutable identifier of a resource (Guid).
     */
    public val uniqueIdentifier: Output<String>
        get() = javaResource.uniqueIdentifier().applyValue({ args0 -> args0 })
}

public object UserMapper : ResourceMapper<User> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.devtestlab.User::class == javaResource::class

    override fun map(javaResource: Resource): User = User(
        javaResource as
            com.pulumi.azurenative.devtestlab.User,
    )
}

/**
 * @see [User].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [User].
 */
public suspend fun user(name: String, block: suspend UserResourceBuilder.() -> Unit): User {
    val builder = UserResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [User].
 * @param name The _unique_ name of the resulting resource.
 */
public fun user(name: String): User {
    val builder = UserResourceBuilder()
    builder.name(name)
    return builder.build()
}
