@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin

import com.pulumi.azurenative.devtestlab.VirtualMachineArgs.builder
import com.pulumi.azurenative.devtestlab.kotlin.inputs.ArtifactInstallPropertiesArgs
import com.pulumi.azurenative.devtestlab.kotlin.inputs.ArtifactInstallPropertiesArgsBuilder
import com.pulumi.azurenative.devtestlab.kotlin.inputs.DataDiskPropertiesArgs
import com.pulumi.azurenative.devtestlab.kotlin.inputs.DataDiskPropertiesArgsBuilder
import com.pulumi.azurenative.devtestlab.kotlin.inputs.GalleryImageReferenceArgs
import com.pulumi.azurenative.devtestlab.kotlin.inputs.GalleryImageReferenceArgsBuilder
import com.pulumi.azurenative.devtestlab.kotlin.inputs.NetworkInterfacePropertiesArgs
import com.pulumi.azurenative.devtestlab.kotlin.inputs.NetworkInterfacePropertiesArgsBuilder
import com.pulumi.azurenative.devtestlab.kotlin.inputs.ScheduleCreationParameterArgs
import com.pulumi.azurenative.devtestlab.kotlin.inputs.ScheduleCreationParameterArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A virtual machine.
 * Azure REST API version: 2018-09-15. Prior API version in Azure Native 1.x: 2018-09-15.
 * Other available API versions: 2016-05-15.
 * ## Example Usage
 * ### VirtualMachines_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.DevTestLab.VirtualMachine("virtualMachine", new()
 *     {
 *         AllowClaim = true,
 *         DisallowPublicIpAddress = true,
 *         GalleryImageReference = new AzureNative.DevTestLab.Inputs.GalleryImageReferenceArgs
 *         {
 *             Offer = "UbuntuServer",
 *             OsType = "Linux",
 *             Publisher = "Canonical",
 *             Sku = "16.04-LTS",
 *             Version = "Latest",
 *         },
 *         LabName = "{labName}",
 *         LabSubnetName = "{virtualNetworkName}Subnet",
 *         LabVirtualNetworkId = "/subscriptions/{subscriptionId}/resourcegroups/resourceGroupName/providers/microsoft.devtestlab/labs/{labName}/virtualnetworks/{virtualNetworkName}",
 *         Location = "{location}",
 *         Name = "{vmName}",
 *         Password = "{userPassword}",
 *         ResourceGroupName = "resourceGroupName",
 *         Size = "Standard_A2_v2",
 *         StorageType = "Standard",
 *         Tags =
 *         {
 *             { "tagName1", "tagValue1" },
 *         },
 *         UserName = "{userName}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/devtestlab/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devtestlab.NewVirtualMachine(ctx, "virtualMachine", &devtestlab.VirtualMachineArgs{
 * 			AllowClaim:              pulumi.Bool(true),
 * 			DisallowPublicIpAddress: pulumi.Bool(true),
 * 			GalleryImageReference: &devtestlab.GalleryImageReferenceArgs{
 * 				Offer:     pulumi.String("UbuntuServer"),
 * 				OsType:    pulumi.String("Linux"),
 * 				Publisher: pulumi.String("Canonical"),
 * 				Sku:       pulumi.String("16.04-LTS"),
 * 				Version:   pulumi.String("Latest"),
 * 			},
 * 			LabName:             pulumi.String("{labName}"),
 * 			LabSubnetName:       pulumi.String("{virtualNetworkName}Subnet"),
 * 			LabVirtualNetworkId: pulumi.String("/subscriptions/{subscriptionId}/resourcegroups/resourceGroupName/providers/microsoft.devtestlab/labs/{labName}/virtualnetworks/{virtualNetworkName}"),
 * 			Location:            pulumi.String("{location}"),
 * 			Name:                pulumi.String("{vmName}"),
 * 			Password:            pulumi.String("{userPassword}"),
 * 			ResourceGroupName:   pulumi.String("resourceGroupName"),
 * 			Size:                pulumi.String("Standard_A2_v2"),
 * 			StorageType:         pulumi.String("Standard"),
 * 			Tags: pulumi.StringMap{
 * 				"tagName1": pulumi.String("tagValue1"),
 * 			},
 * 			UserName: pulumi.String("{userName}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.devtestlab.VirtualMachine;
 * import com.pulumi.azurenative.devtestlab.VirtualMachineArgs;
 * import com.pulumi.azurenative.devtestlab.inputs.GalleryImageReferenceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .allowClaim(true)
 *             .disallowPublicIpAddress(true)
 *             .galleryImageReference(GalleryImageReferenceArgs.builder()
 *                 .offer("UbuntuServer")
 *                 .osType("Linux")
 *                 .publisher("Canonical")
 *                 .sku("16.04-LTS")
 *                 .version("Latest")
 *                 .build())
 *             .labName("{labName}")
 *             .labSubnetName("{virtualNetworkName}Subnet")
 *             .labVirtualNetworkId("/subscriptions/{subscriptionId}/resourcegroups/resourceGroupName/providers/microsoft.devtestlab/labs/{labName}/virtualnetworks/{virtualNetworkName}")
 *             .location("{location}")
 *             .name("{vmName}")
 *             .password("{userPassword}")
 *             .resourceGroupName("resourceGroupName")
 *             .size("Standard_A2_v2")
 *             .storageType("Standard")
 *             .tags(Map.of("tagName1", "tagValue1"))
 *             .userName("{userName}")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:devtestlab:VirtualMachine {vmName} /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/virtualmachines/{name}
 * ```
 * @property allowClaim Indicates whether another user can take ownership of the virtual machine
 * @property artifacts The artifacts to be installed on the virtual machine.
 * @property createdDate The creation date of the virtual machine.
 * @property customImageId The custom image identifier of the virtual machine.
 * @property dataDiskParameters New or existing data disks to attach to the virtual machine after creation
 * @property disallowPublicIpAddress Indicates whether the virtual machine is to be created without a public IP address.
 * @property environmentId The resource ID of the environment that contains this virtual machine, if any.
 * @property expirationDate The expiration date for VM.
 * @property galleryImageReference The Microsoft Azure Marketplace image reference of the virtual machine.
 * @property isAuthenticationWithSshKey Indicates whether this virtual machine uses an SSH key for authentication.
 * @property labName The name of the lab.
 * @property labSubnetName The lab subnet name of the virtual machine.
 * @property labVirtualNetworkId The lab virtual network identifier of the virtual machine.
 * @property location The location of the resource.
 * @property name The name of the virtual machine.
 * @property networkInterface The network interface properties.
 * @property notes The notes of the virtual machine.
 * @property ownerObjectId The object identifier of the owner of the virtual machine.
 * @property ownerUserPrincipalName The user principal name of the virtual machine owner.
 * @property password The password of the virtual machine administrator.
 * @property planId The id of the plan associated with the virtual machine image
 * @property resourceGroupName The name of the resource group.
 * @property scheduleParameters Virtual Machine schedules to be created
 * @property size The size of the virtual machine.
 * @property sshKey The SSH key of the virtual machine administrator.
 * @property storageType Storage type to use for virtual machine (i.e. Standard, Premium).
 * @property tags The tags of the resource.
 * @property userName The user name of the virtual machine.
 */
public data class VirtualMachineArgs(
    public val allowClaim: Output<Boolean>? = null,
    public val artifacts: Output<List<ArtifactInstallPropertiesArgs>>? = null,
    public val createdDate: Output<String>? = null,
    public val customImageId: Output<String>? = null,
    public val dataDiskParameters: Output<List<DataDiskPropertiesArgs>>? = null,
    public val disallowPublicIpAddress: Output<Boolean>? = null,
    public val environmentId: Output<String>? = null,
    public val expirationDate: Output<String>? = null,
    public val galleryImageReference: Output<GalleryImageReferenceArgs>? = null,
    public val isAuthenticationWithSshKey: Output<Boolean>? = null,
    public val labName: Output<String>? = null,
    public val labSubnetName: Output<String>? = null,
    public val labVirtualNetworkId: Output<String>? = null,
    public val location: Output<String>? = null,
    public val name: Output<String>? = null,
    public val networkInterface: Output<NetworkInterfacePropertiesArgs>? = null,
    public val notes: Output<String>? = null,
    public val ownerObjectId: Output<String>? = null,
    public val ownerUserPrincipalName: Output<String>? = null,
    public val password: Output<String>? = null,
    public val planId: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val scheduleParameters: Output<List<ScheduleCreationParameterArgs>>? = null,
    public val size: Output<String>? = null,
    public val sshKey: Output<String>? = null,
    public val storageType: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val userName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devtestlab.VirtualMachineArgs> {
    override fun toJava(): com.pulumi.azurenative.devtestlab.VirtualMachineArgs =
        com.pulumi.azurenative.devtestlab.VirtualMachineArgs.builder()
            .allowClaim(allowClaim?.applyValue({ args0 -> args0 }))
            .artifacts(
                artifacts?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .createdDate(createdDate?.applyValue({ args0 -> args0 }))
            .customImageId(customImageId?.applyValue({ args0 -> args0 }))
            .dataDiskParameters(
                dataDiskParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .disallowPublicIpAddress(disallowPublicIpAddress?.applyValue({ args0 -> args0 }))
            .environmentId(environmentId?.applyValue({ args0 -> args0 }))
            .expirationDate(expirationDate?.applyValue({ args0 -> args0 }))
            .galleryImageReference(
                galleryImageReference?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .isAuthenticationWithSshKey(isAuthenticationWithSshKey?.applyValue({ args0 -> args0 }))
            .labName(labName?.applyValue({ args0 -> args0 }))
            .labSubnetName(labSubnetName?.applyValue({ args0 -> args0 }))
            .labVirtualNetworkId(labVirtualNetworkId?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .networkInterface(networkInterface?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .notes(notes?.applyValue({ args0 -> args0 }))
            .ownerObjectId(ownerObjectId?.applyValue({ args0 -> args0 }))
            .ownerUserPrincipalName(ownerUserPrincipalName?.applyValue({ args0 -> args0 }))
            .password(password?.applyValue({ args0 -> args0 }))
            .planId(planId?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .scheduleParameters(
                scheduleParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .size(size?.applyValue({ args0 -> args0 }))
            .sshKey(sshKey?.applyValue({ args0 -> args0 }))
            .storageType(storageType?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .userName(userName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualMachineArgs].
 */
@PulumiTagMarker
public class VirtualMachineArgsBuilder internal constructor() {
    private var allowClaim: Output<Boolean>? = null

    private var artifacts: Output<List<ArtifactInstallPropertiesArgs>>? = null

    private var createdDate: Output<String>? = null

    private var customImageId: Output<String>? = null

    private var dataDiskParameters: Output<List<DataDiskPropertiesArgs>>? = null

    private var disallowPublicIpAddress: Output<Boolean>? = null

    private var environmentId: Output<String>? = null

    private var expirationDate: Output<String>? = null

    private var galleryImageReference: Output<GalleryImageReferenceArgs>? = null

    private var isAuthenticationWithSshKey: Output<Boolean>? = null

    private var labName: Output<String>? = null

    private var labSubnetName: Output<String>? = null

    private var labVirtualNetworkId: Output<String>? = null

    private var location: Output<String>? = null

    private var name: Output<String>? = null

    private var networkInterface: Output<NetworkInterfacePropertiesArgs>? = null

    private var notes: Output<String>? = null

    private var ownerObjectId: Output<String>? = null

    private var ownerUserPrincipalName: Output<String>? = null

    private var password: Output<String>? = null

    private var planId: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var scheduleParameters: Output<List<ScheduleCreationParameterArgs>>? = null

    private var size: Output<String>? = null

    private var sshKey: Output<String>? = null

    private var storageType: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var userName: Output<String>? = null

    /**
     * @param value Indicates whether another user can take ownership of the virtual machine
     */
    @JvmName("bfertnsyghqdvlsl")
    public suspend fun allowClaim(`value`: Output<Boolean>) {
        this.allowClaim = value
    }

    /**
     * @param value The artifacts to be installed on the virtual machine.
     */
    @JvmName("atrwycujlyjxtiyp")
    public suspend fun artifacts(`value`: Output<List<ArtifactInstallPropertiesArgs>>) {
        this.artifacts = value
    }

    @JvmName("aaxdcodxowilyvay")
    public suspend fun artifacts(vararg values: Output<ArtifactInstallPropertiesArgs>) {
        this.artifacts = Output.all(values.asList())
    }

    /**
     * @param values The artifacts to be installed on the virtual machine.
     */
    @JvmName("pfmnmuqohkhsrsjr")
    public suspend fun artifacts(values: List<Output<ArtifactInstallPropertiesArgs>>) {
        this.artifacts = Output.all(values)
    }

    /**
     * @param value The creation date of the virtual machine.
     */
    @JvmName("bdwkmklphkjhhxlm")
    public suspend fun createdDate(`value`: Output<String>) {
        this.createdDate = value
    }

    /**
     * @param value The custom image identifier of the virtual machine.
     */
    @JvmName("errlwcrebrreaerb")
    public suspend fun customImageId(`value`: Output<String>) {
        this.customImageId = value
    }

    /**
     * @param value New or existing data disks to attach to the virtual machine after creation
     */
    @JvmName("gvgbxmkdabiukxrg")
    public suspend fun dataDiskParameters(`value`: Output<List<DataDiskPropertiesArgs>>) {
        this.dataDiskParameters = value
    }

    @JvmName("nuqspbujlpkqgwop")
    public suspend fun dataDiskParameters(vararg values: Output<DataDiskPropertiesArgs>) {
        this.dataDiskParameters = Output.all(values.asList())
    }

    /**
     * @param values New or existing data disks to attach to the virtual machine after creation
     */
    @JvmName("eahxooxjompncseg")
    public suspend fun dataDiskParameters(values: List<Output<DataDiskPropertiesArgs>>) {
        this.dataDiskParameters = Output.all(values)
    }

    /**
     * @param value Indicates whether the virtual machine is to be created without a public IP address.
     */
    @JvmName("wsoqclcnjufingqs")
    public suspend fun disallowPublicIpAddress(`value`: Output<Boolean>) {
        this.disallowPublicIpAddress = value
    }

    /**
     * @param value The resource ID of the environment that contains this virtual machine, if any.
     */
    @JvmName("beyfwfrepmfrurly")
    public suspend fun environmentId(`value`: Output<String>) {
        this.environmentId = value
    }

    /**
     * @param value The expiration date for VM.
     */
    @JvmName("yciishrjmnlcjnai")
    public suspend fun expirationDate(`value`: Output<String>) {
        this.expirationDate = value
    }

    /**
     * @param value The Microsoft Azure Marketplace image reference of the virtual machine.
     */
    @JvmName("asvtvdycyvnmfvvd")
    public suspend fun galleryImageReference(`value`: Output<GalleryImageReferenceArgs>) {
        this.galleryImageReference = value
    }

    /**
     * @param value Indicates whether this virtual machine uses an SSH key for authentication.
     */
    @JvmName("cwgbikauvmfsnyid")
    public suspend fun isAuthenticationWithSshKey(`value`: Output<Boolean>) {
        this.isAuthenticationWithSshKey = value
    }

    /**
     * @param value The name of the lab.
     */
    @JvmName("hxutwmjdpcdyqmmx")
    public suspend fun labName(`value`: Output<String>) {
        this.labName = value
    }

    /**
     * @param value The lab subnet name of the virtual machine.
     */
    @JvmName("vxmcmtsajpjlsart")
    public suspend fun labSubnetName(`value`: Output<String>) {
        this.labSubnetName = value
    }

    /**
     * @param value The lab virtual network identifier of the virtual machine.
     */
    @JvmName("smxgbhosrhdrpajk")
    public suspend fun labVirtualNetworkId(`value`: Output<String>) {
        this.labVirtualNetworkId = value
    }

    /**
     * @param value The location of the resource.
     */
    @JvmName("bneglmytggpfuitv")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the virtual machine.
     */
    @JvmName("fjyqearhfbnibiqx")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The network interface properties.
     */
    @JvmName("aslmbxvguqoktucs")
    public suspend fun networkInterface(`value`: Output<NetworkInterfacePropertiesArgs>) {
        this.networkInterface = value
    }

    /**
     * @param value The notes of the virtual machine.
     */
    @JvmName("smaugkgsppluknjb")
    public suspend fun notes(`value`: Output<String>) {
        this.notes = value
    }

    /**
     * @param value The object identifier of the owner of the virtual machine.
     */
    @JvmName("uqjkyansgwmmgqvt")
    public suspend fun ownerObjectId(`value`: Output<String>) {
        this.ownerObjectId = value
    }

    /**
     * @param value The user principal name of the virtual machine owner.
     */
    @JvmName("hoqkdjnufipcgmya")
    public suspend fun ownerUserPrincipalName(`value`: Output<String>) {
        this.ownerUserPrincipalName = value
    }

    /**
     * @param value The password of the virtual machine administrator.
     */
    @JvmName("fwrgwdaiqywfteki")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value The id of the plan associated with the virtual machine image
     */
    @JvmName("vwpbdtbapduofvim")
    public suspend fun planId(`value`: Output<String>) {
        this.planId = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("lwqdxhbglaemvrot")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Virtual Machine schedules to be created
     */
    @JvmName("haopfpbxrusofkgb")
    public suspend fun scheduleParameters(`value`: Output<List<ScheduleCreationParameterArgs>>) {
        this.scheduleParameters = value
    }

    @JvmName("ovxkhtcebvvirtwu")
    public suspend fun scheduleParameters(vararg values: Output<ScheduleCreationParameterArgs>) {
        this.scheduleParameters = Output.all(values.asList())
    }

    /**
     * @param values Virtual Machine schedules to be created
     */
    @JvmName("qrtuasyqbwxlcxvy")
    public suspend fun scheduleParameters(values: List<Output<ScheduleCreationParameterArgs>>) {
        this.scheduleParameters = Output.all(values)
    }

    /**
     * @param value The size of the virtual machine.
     */
    @JvmName("ctgcwoyckwkbqoem")
    public suspend fun size(`value`: Output<String>) {
        this.size = value
    }

    /**
     * @param value The SSH key of the virtual machine administrator.
     */
    @JvmName("lxwurodhjkgrpubp")
    public suspend fun sshKey(`value`: Output<String>) {
        this.sshKey = value
    }

    /**
     * @param value Storage type to use for virtual machine (i.e. Standard, Premium).
     */
    @JvmName("ullxovfpmupeojff")
    public suspend fun storageType(`value`: Output<String>) {
        this.storageType = value
    }

    /**
     * @param value The tags of the resource.
     */
    @JvmName("tvqwgkfjokggqyvp")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The user name of the virtual machine.
     */
    @JvmName("kpttmtmusduaonan")
    public suspend fun userName(`value`: Output<String>) {
        this.userName = value
    }

    /**
     * @param value Indicates whether another user can take ownership of the virtual machine
     */
    @JvmName("bujbelprxrgilfst")
    public suspend fun allowClaim(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowClaim = mapped
    }

    /**
     * @param value The artifacts to be installed on the virtual machine.
     */
    @JvmName("mjjjuqxoncbnhmnn")
    public suspend fun artifacts(`value`: List<ArtifactInstallPropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.artifacts = mapped
    }

    /**
     * @param argument The artifacts to be installed on the virtual machine.
     */
    @JvmName("dlfjgvgiiacxknyx")
    public suspend fun artifacts(argument: List<suspend ArtifactInstallPropertiesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ArtifactInstallPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.artifacts = mapped
    }

    /**
     * @param argument The artifacts to be installed on the virtual machine.
     */
    @JvmName("mqwljroqwwofftqh")
    public suspend fun artifacts(vararg argument: suspend ArtifactInstallPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ArtifactInstallPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.artifacts = mapped
    }

    /**
     * @param argument The artifacts to be installed on the virtual machine.
     */
    @JvmName("ijqoxcmxflvytmov")
    public suspend fun artifacts(argument: suspend ArtifactInstallPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ArtifactInstallPropertiesArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.artifacts = mapped
    }

    /**
     * @param values The artifacts to be installed on the virtual machine.
     */
    @JvmName("jobxqroryvkefjsm")
    public suspend fun artifacts(vararg values: ArtifactInstallPropertiesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.artifacts = mapped
    }

    /**
     * @param value The creation date of the virtual machine.
     */
    @JvmName("dpfjoxwnbvdyghss")
    public suspend fun createdDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.createdDate = mapped
    }

    /**
     * @param value The custom image identifier of the virtual machine.
     */
    @JvmName("wwnnxaamjfhjubbf")
    public suspend fun customImageId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customImageId = mapped
    }

    /**
     * @param value New or existing data disks to attach to the virtual machine after creation
     */
    @JvmName("vehqggsjxevwknip")
    public suspend fun dataDiskParameters(`value`: List<DataDiskPropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataDiskParameters = mapped
    }

    /**
     * @param argument New or existing data disks to attach to the virtual machine after creation
     */
    @JvmName("tjlhupkafxsqekvw")
    public suspend fun dataDiskParameters(argument: List<suspend DataDiskPropertiesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DataDiskPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dataDiskParameters = mapped
    }

    /**
     * @param argument New or existing data disks to attach to the virtual machine after creation
     */
    @JvmName("qjppywqsjhxjtohv")
    public suspend fun dataDiskParameters(vararg argument: suspend DataDiskPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DataDiskPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dataDiskParameters = mapped
    }

    /**
     * @param argument New or existing data disks to attach to the virtual machine after creation
     */
    @JvmName("agvruuuwobunkrqd")
    public suspend fun dataDiskParameters(argument: suspend DataDiskPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DataDiskPropertiesArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.dataDiskParameters = mapped
    }

    /**
     * @param values New or existing data disks to attach to the virtual machine after creation
     */
    @JvmName("obohfaofsmnykakf")
    public suspend fun dataDiskParameters(vararg values: DataDiskPropertiesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataDiskParameters = mapped
    }

    /**
     * @param value Indicates whether the virtual machine is to be created without a public IP address.
     */
    @JvmName("ekvegqgmeyvyaeag")
    public suspend fun disallowPublicIpAddress(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disallowPublicIpAddress = mapped
    }

    /**
     * @param value The resource ID of the environment that contains this virtual machine, if any.
     */
    @JvmName("pydfumkmaxdburko")
    public suspend fun environmentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentId = mapped
    }

    /**
     * @param value The expiration date for VM.
     */
    @JvmName("yinddhxpjainethx")
    public suspend fun expirationDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expirationDate = mapped
    }

    /**
     * @param value The Microsoft Azure Marketplace image reference of the virtual machine.
     */
    @JvmName("bqdxryepoecskwas")
    public suspend fun galleryImageReference(`value`: GalleryImageReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.galleryImageReference = mapped
    }

    /**
     * @param argument The Microsoft Azure Marketplace image reference of the virtual machine.
     */
    @JvmName("auorpgfhgdbvligo")
    public suspend fun galleryImageReference(argument: suspend GalleryImageReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = GalleryImageReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.galleryImageReference = mapped
    }

    /**
     * @param value Indicates whether this virtual machine uses an SSH key for authentication.
     */
    @JvmName("aqiqpllssqqpmgqx")
    public suspend fun isAuthenticationWithSshKey(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isAuthenticationWithSshKey = mapped
    }

    /**
     * @param value The name of the lab.
     */
    @JvmName("evhvhruvguqlosob")
    public suspend fun labName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labName = mapped
    }

    /**
     * @param value The lab subnet name of the virtual machine.
     */
    @JvmName("vvlxkodcdcrlknmy")
    public suspend fun labSubnetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labSubnetName = mapped
    }

    /**
     * @param value The lab virtual network identifier of the virtual machine.
     */
    @JvmName("loqtlaketynpvfyj")
    public suspend fun labVirtualNetworkId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labVirtualNetworkId = mapped
    }

    /**
     * @param value The location of the resource.
     */
    @JvmName("arsyxwauknbetpyg")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the virtual machine.
     */
    @JvmName("efygsndfmxgdrpun")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The network interface properties.
     */
    @JvmName("foueqccyjqjalpbu")
    public suspend fun networkInterface(`value`: NetworkInterfacePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkInterface = mapped
    }

    /**
     * @param argument The network interface properties.
     */
    @JvmName("rrgadesyxalyafyb")
    public suspend fun networkInterface(argument: suspend NetworkInterfacePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = NetworkInterfacePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.networkInterface = mapped
    }

    /**
     * @param value The notes of the virtual machine.
     */
    @JvmName("wixwfgrkhfdjgypb")
    public suspend fun notes(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notes = mapped
    }

    /**
     * @param value The object identifier of the owner of the virtual machine.
     */
    @JvmName("nnaifwxghvuhdgyy")
    public suspend fun ownerObjectId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ownerObjectId = mapped
    }

    /**
     * @param value The user principal name of the virtual machine owner.
     */
    @JvmName("sjofkkosbkklnxnu")
    public suspend fun ownerUserPrincipalName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ownerUserPrincipalName = mapped
    }

    /**
     * @param value The password of the virtual machine administrator.
     */
    @JvmName("iapjjfgvgqgbamqm")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The id of the plan associated with the virtual machine image
     */
    @JvmName("jpcfcwfxahunnjhq")
    public suspend fun planId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.planId = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("vswibvmmpilrwspq")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Virtual Machine schedules to be created
     */
    @JvmName("cwtymfrivhabvqop")
    public suspend fun scheduleParameters(`value`: List<ScheduleCreationParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scheduleParameters = mapped
    }

    /**
     * @param argument Virtual Machine schedules to be created
     */
    @JvmName("xweqabrmjvvxculu")
    public suspend fun scheduleParameters(argument: List<suspend ScheduleCreationParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ScheduleCreationParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.scheduleParameters = mapped
    }

    /**
     * @param argument Virtual Machine schedules to be created
     */
    @JvmName("visfhuvqjrerxbov")
    public suspend fun scheduleParameters(vararg argument: suspend ScheduleCreationParameterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ScheduleCreationParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.scheduleParameters = mapped
    }

    /**
     * @param argument Virtual Machine schedules to be created
     */
    @JvmName("uldynmwaxcexjbjc")
    public suspend fun scheduleParameters(argument: suspend ScheduleCreationParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ScheduleCreationParameterArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.scheduleParameters = mapped
    }

    /**
     * @param values Virtual Machine schedules to be created
     */
    @JvmName("gsrrxqcqqmxclhfk")
    public suspend fun scheduleParameters(vararg values: ScheduleCreationParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scheduleParameters = mapped
    }

    /**
     * @param value The size of the virtual machine.
     */
    @JvmName("cgidbaqjgdgpjxcy")
    public suspend fun size(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.size = mapped
    }

    /**
     * @param value The SSH key of the virtual machine administrator.
     */
    @JvmName("ltdkmcgjvykakthb")
    public suspend fun sshKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sshKey = mapped
    }

    /**
     * @param value Storage type to use for virtual machine (i.e. Standard, Premium).
     */
    @JvmName("ywtkywghastvmdmc")
    public suspend fun storageType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageType = mapped
    }

    /**
     * @param value The tags of the resource.
     */
    @JvmName("akeilcfuscdiwvxb")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tags of the resource.
     */
    @JvmName("ndrolayyolcrscar")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The user name of the virtual machine.
     */
    @JvmName("egtkuvmnwkcjdwkc")
    public suspend fun userName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userName = mapped
    }

    internal fun build(): VirtualMachineArgs = VirtualMachineArgs(
        allowClaim = allowClaim,
        artifacts = artifacts,
        createdDate = createdDate,
        customImageId = customImageId,
        dataDiskParameters = dataDiskParameters,
        disallowPublicIpAddress = disallowPublicIpAddress,
        environmentId = environmentId,
        expirationDate = expirationDate,
        galleryImageReference = galleryImageReference,
        isAuthenticationWithSshKey = isAuthenticationWithSshKey,
        labName = labName,
        labSubnetName = labSubnetName,
        labVirtualNetworkId = labVirtualNetworkId,
        location = location,
        name = name,
        networkInterface = networkInterface,
        notes = notes,
        ownerObjectId = ownerObjectId,
        ownerUserPrincipalName = ownerUserPrincipalName,
        password = password,
        planId = planId,
        resourceGroupName = resourceGroupName,
        scheduleParameters = scheduleParameters,
        size = size,
        sshKey = sshKey,
        storageType = storageType,
        tags = tags,
        userName = userName,
    )
}
