@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin

import com.pulumi.azurenative.devtestlab.kotlin.outputs.ExternalSubnetResponse
import com.pulumi.azurenative.devtestlab.kotlin.outputs.SubnetOverrideResponse
import com.pulumi.azurenative.devtestlab.kotlin.outputs.SubnetResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.devtestlab.kotlin.outputs.ExternalSubnetResponse.Companion.toKotlin as externalSubnetResponseToKotlin
import com.pulumi.azurenative.devtestlab.kotlin.outputs.SubnetOverrideResponse.Companion.toKotlin as subnetOverrideResponseToKotlin
import com.pulumi.azurenative.devtestlab.kotlin.outputs.SubnetResponse.Companion.toKotlin as subnetResponseToKotlin

/**
 * Builder for [VirtualNetwork].
 */
@PulumiTagMarker
public class VirtualNetworkResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VirtualNetworkArgs = VirtualNetworkArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VirtualNetworkArgsBuilder.() -> Unit) {
        val builder = VirtualNetworkArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): VirtualNetwork {
        val builtJavaResource =
            com.pulumi.azurenative.devtestlab.VirtualNetwork(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return VirtualNetwork(builtJavaResource)
    }
}

/**
 * A virtual network.
 * Azure REST API version: 2018-09-15. Prior API version in Azure Native 1.x: 2018-09-15.
 * Other available API versions: 2016-05-15.
 * ## Example Usage
 * ### VirtualNetworks_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualNetwork = new AzureNative.DevTestLab.VirtualNetwork("virtualNetwork", new()
 *     {
 *         LabName = "{labName}",
 *         Location = "{location}",
 *         Name = "{virtualNetworkName}",
 *         ResourceGroupName = "resourceGroupName",
 *         Tags =
 *         {
 *             { "tagName1", "tagValue1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/devtestlab/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devtestlab.NewVirtualNetwork(ctx, "virtualNetwork", &devtestlab.VirtualNetworkArgs{
 * 			LabName:           pulumi.String("{labName}"),
 * 			Location:          pulumi.String("{location}"),
 * 			Name:              pulumi.String("{virtualNetworkName}"),
 * 			ResourceGroupName: pulumi.String("resourceGroupName"),
 * 			Tags: pulumi.StringMap{
 * 				"tagName1": pulumi.String("tagValue1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.devtestlab.VirtualNetwork;
 * import com.pulumi.azurenative.devtestlab.VirtualNetworkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualNetwork = new VirtualNetwork("virtualNetwork", VirtualNetworkArgs.builder()
 *             .labName("{labName}")
 *             .location("{location}")
 *             .name("{virtualNetworkName}")
 *             .resourceGroupName("resourceGroupName")
 *             .tags(Map.of("tagName1", "tagValue1"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:devtestlab:VirtualNetwork {virtualNetworkName} /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/virtualnetworks/{name}
 * ```
 */
public class VirtualNetwork internal constructor(
    override val javaResource: com.pulumi.azurenative.devtestlab.VirtualNetwork,
) : KotlinCustomResource(javaResource, VirtualNetworkMapper) {
    /**
     * The allowed subnets of the virtual network.
     */
    public val allowedSubnets: Output<List<SubnetResponse>>?
        get() = javaResource.allowedSubnets().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.let({ args0 -> subnetResponseToKotlin(args0) }) })
            }).orElse(null)
        })

    /**
     * The creation date of the virtual network.
     */
    public val createdDate: Output<String>
        get() = javaResource.createdDate().applyValue({ args0 -> args0 })

    /**
     * The description of the virtual network.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Microsoft.Network resource identifier of the virtual network.
     */
    public val externalProviderResourceId: Output<String>?
        get() = javaResource.externalProviderResourceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The external subnet properties.
     */
    public val externalSubnets: Output<List<ExternalSubnetResponse>>
        get() = javaResource.externalSubnets().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> externalSubnetResponseToKotlin(args0) })
            })
        })

    /**
     * The location of the resource.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning status of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The subnet overrides of the virtual network.
     */
    public val subnetOverrides: Output<List<SubnetOverrideResponse>>?
        get() = javaResource.subnetOverrides().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        subnetOverrideResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The tags of the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The unique immutable identifier of a resource (Guid).
     */
    public val uniqueIdentifier: Output<String>
        get() = javaResource.uniqueIdentifier().applyValue({ args0 -> args0 })
}

public object VirtualNetworkMapper : ResourceMapper<VirtualNetwork> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.devtestlab.VirtualNetwork::class == javaResource::class

    override fun map(javaResource: Resource): VirtualNetwork = VirtualNetwork(
        javaResource as
            com.pulumi.azurenative.devtestlab.VirtualNetwork,
    )
}

/**
 * @see [VirtualNetwork].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VirtualNetwork].
 */
public suspend fun virtualNetwork(
    name: String,
    block: suspend VirtualNetworkResourceBuilder.() -> Unit,
): VirtualNetwork {
    val builder = VirtualNetworkResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VirtualNetwork].
 * @param name The _unique_ name of the resulting resource.
 */
public fun virtualNetwork(name: String): VirtualNetwork {
    val builder = VirtualNetworkResourceBuilder()
    builder.name(name)
    return builder.build()
}
