@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The OS type of the custom image (i.e. Windows, Linux)
 */
public enum class CustomImageOsType(
    public val javaValue: com.pulumi.azurenative.devtestlab.enums.CustomImageOsType,
) : ConvertibleToJava<com.pulumi.azurenative.devtestlab.enums.CustomImageOsType> {
    Windows(com.pulumi.azurenative.devtestlab.enums.CustomImageOsType.Windows),
    Linux(com.pulumi.azurenative.devtestlab.enums.CustomImageOsType.Linux),
    None(com.pulumi.azurenative.devtestlab.enums.CustomImageOsType.None),
    ;

    override fun toJava(): com.pulumi.azurenative.devtestlab.enums.CustomImageOsType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devtestlab.enums.CustomImageOsType): CustomImageOsType = CustomImageOsType.values().first { it.javaValue == javaType }
    }
}
