@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The fact name of the policy (e.g. LabVmCount, LabVmSize, MaxVmsAllowedPerLab, etc.
 */
public enum class PolicyFactName(
    public val javaValue: com.pulumi.azurenative.devtestlab.enums.PolicyFactName,
) : ConvertibleToJava<com.pulumi.azurenative.devtestlab.enums.PolicyFactName> {
    UserOwnedLabVmCount(com.pulumi.azurenative.devtestlab.enums.PolicyFactName.UserOwnedLabVmCount),
    UserOwnedLabPremiumVmCount(com.pulumi.azurenative.devtestlab.enums.PolicyFactName.UserOwnedLabPremiumVmCount),
    LabVmCount(com.pulumi.azurenative.devtestlab.enums.PolicyFactName.LabVmCount),
    LabPremiumVmCount(com.pulumi.azurenative.devtestlab.enums.PolicyFactName.LabPremiumVmCount),
    LabVmSize(com.pulumi.azurenative.devtestlab.enums.PolicyFactName.LabVmSize),
    GalleryImage(com.pulumi.azurenative.devtestlab.enums.PolicyFactName.GalleryImage),
    UserOwnedLabVmCountInSubnet(com.pulumi.azurenative.devtestlab.enums.PolicyFactName.UserOwnedLabVmCountInSubnet),
    LabTargetCost(com.pulumi.azurenative.devtestlab.enums.PolicyFactName.LabTargetCost),
    EnvironmentTemplate(com.pulumi.azurenative.devtestlab.enums.PolicyFactName.EnvironmentTemplate),
    ScheduleEditPermission(com.pulumi.azurenative.devtestlab.enums.PolicyFactName.ScheduleEditPermission),
    ;

    override fun toJava(): com.pulumi.azurenative.devtestlab.enums.PolicyFactName = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devtestlab.enums.PolicyFactName): PolicyFactName = PolicyFactName.values().first { it.javaValue == javaType }
    }
}
