@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The setting to enable usage of premium data disks.
 * When its value is 'Enabled', creation of standard or premium data disks is allowed.
 * When its value is 'Disabled', only creation of standard data disks is allowed.
 */
public enum class PremiumDataDisk(
    public val javaValue: com.pulumi.azurenative.devtestlab.enums.PremiumDataDisk,
) : ConvertibleToJava<com.pulumi.azurenative.devtestlab.enums.PremiumDataDisk> {
    Disabled(com.pulumi.azurenative.devtestlab.enums.PremiumDataDisk.Disabled),
    Enabled(com.pulumi.azurenative.devtestlab.enums.PremiumDataDisk.Enabled),
    ;

    override fun toJava(): com.pulumi.azurenative.devtestlab.enums.PremiumDataDisk = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devtestlab.enums.PremiumDataDisk): PremiumDataDisk = PremiumDataDisk.values().first { it.javaValue == javaType }
    }
}
