@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The storage type for the disk (i.e. Standard, Premium).
 */
public enum class StorageType(
    public val javaValue: com.pulumi.azurenative.devtestlab.enums.StorageType,
) : ConvertibleToJava<com.pulumi.azurenative.devtestlab.enums.StorageType> {
    Standard(com.pulumi.azurenative.devtestlab.enums.StorageType.Standard),
    Premium(com.pulumi.azurenative.devtestlab.enums.StorageType.Premium),
    StandardSSD(com.pulumi.azurenative.devtestlab.enums.StorageType.StandardSSD),
    ;

    override fun toJava(): com.pulumi.azurenative.devtestlab.enums.StorageType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devtestlab.enums.StorageType): StorageType = StorageType.values().first { it.javaValue == javaType }
    }
}
