@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Indicates whether public IP addresses can be assigned to virtual machines on this subnet (i.e. Allow, Deny).
 */
public enum class UsagePermissionType(
    public val javaValue: com.pulumi.azurenative.devtestlab.enums.UsagePermissionType,
) : ConvertibleToJava<com.pulumi.azurenative.devtestlab.enums.UsagePermissionType> {
    Default(com.pulumi.azurenative.devtestlab.enums.UsagePermissionType.Default),
    Deny(com.pulumi.azurenative.devtestlab.enums.UsagePermissionType.Deny),
    Allow(com.pulumi.azurenative.devtestlab.enums.UsagePermissionType.Allow),
    ;

    override fun toJava(): com.pulumi.azurenative.devtestlab.enums.UsagePermissionType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devtestlab.enums.UsagePermissionType): UsagePermissionType = UsagePermissionType.values().first { it.javaValue == javaType }
    }
}
