@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The state of the Windows OS (i.e. NonSysprepped, SysprepRequested, SysprepApplied).
 */
public enum class WindowsOsState(
    public val javaValue: com.pulumi.azurenative.devtestlab.enums.WindowsOsState,
) : ConvertibleToJava<com.pulumi.azurenative.devtestlab.enums.WindowsOsState> {
    NonSysprepped(com.pulumi.azurenative.devtestlab.enums.WindowsOsState.NonSysprepped),
    SysprepRequested(com.pulumi.azurenative.devtestlab.enums.WindowsOsState.SysprepRequested),
    SysprepApplied(com.pulumi.azurenative.devtestlab.enums.WindowsOsState.SysprepApplied),
    ;

    override fun toJava(): com.pulumi.azurenative.devtestlab.enums.WindowsOsState = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devtestlab.enums.WindowsOsState): WindowsOsState = WindowsOsState.values().first { it.javaValue == javaType }
    }
}
