@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.inputs

import com.pulumi.azurenative.devtestlab.inputs.ArtifactParameterPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Properties of an artifact parameter.
 * @property name The name of the artifact parameter.
 * @property value The value of the artifact parameter.
 */
public data class ArtifactParameterPropertiesArgs(
    public val name: Output<String>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devtestlab.inputs.ArtifactParameterPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.devtestlab.inputs.ArtifactParameterPropertiesArgs =
        com.pulumi.azurenative.devtestlab.inputs.ArtifactParameterPropertiesArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ArtifactParameterPropertiesArgs].
 */
@PulumiTagMarker
public class ArtifactParameterPropertiesArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The name of the artifact parameter.
     */
    @JvmName("rrssqdmhnfmkqxhw")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The value of the artifact parameter.
     */
    @JvmName("vjolonupwtaqktpp")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The name of the artifact parameter.
     */
    @JvmName("hocuiojykjudsrdg")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The value of the artifact parameter.
     */
    @JvmName("sswksqnwfbfrranh")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): ArtifactParameterPropertiesArgs = ArtifactParameterPropertiesArgs(
        name = name,
        `value` = `value`,
    )
}
