@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.inputs

import com.pulumi.azurenative.devtestlab.inputs.AttachNewDataDiskOptionsArgs.builder
import com.pulumi.azurenative.devtestlab.kotlin.enums.StorageType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Properties to attach new disk to the Virtual Machine.
 * @property diskName The name of the disk to be attached.
 * @property diskSizeGiB Size of the disk to be attached in Gibibytes.
 * @property diskType The storage type for the disk (i.e. Standard, Premium).
 */
public data class AttachNewDataDiskOptionsArgs(
    public val diskName: Output<String>? = null,
    public val diskSizeGiB: Output<Int>? = null,
    public val diskType: Output<Either<String, StorageType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devtestlab.inputs.AttachNewDataDiskOptionsArgs> {
    override fun toJava(): com.pulumi.azurenative.devtestlab.inputs.AttachNewDataDiskOptionsArgs =
        com.pulumi.azurenative.devtestlab.inputs.AttachNewDataDiskOptionsArgs.builder()
            .diskName(diskName?.applyValue({ args0 -> args0 }))
            .diskSizeGiB(diskSizeGiB?.applyValue({ args0 -> args0 }))
            .diskType(
                diskType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [AttachNewDataDiskOptionsArgs].
 */
@PulumiTagMarker
public class AttachNewDataDiskOptionsArgsBuilder internal constructor() {
    private var diskName: Output<String>? = null

    private var diskSizeGiB: Output<Int>? = null

    private var diskType: Output<Either<String, StorageType>>? = null

    /**
     * @param value The name of the disk to be attached.
     */
    @JvmName("ierrwwtvihecjsjm")
    public suspend fun diskName(`value`: Output<String>) {
        this.diskName = value
    }

    /**
     * @param value Size of the disk to be attached in Gibibytes.
     */
    @JvmName("uempbtokcwyoxrry")
    public suspend fun diskSizeGiB(`value`: Output<Int>) {
        this.diskSizeGiB = value
    }

    /**
     * @param value The storage type for the disk (i.e. Standard, Premium).
     */
    @JvmName("wquvaqqvkucjlvse")
    public suspend fun diskType(`value`: Output<Either<String, StorageType>>) {
        this.diskType = value
    }

    /**
     * @param value The name of the disk to be attached.
     */
    @JvmName("cbyhaxygnwvgjqng")
    public suspend fun diskName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskName = mapped
    }

    /**
     * @param value Size of the disk to be attached in Gibibytes.
     */
    @JvmName("imjahubpsqxcsyym")
    public suspend fun diskSizeGiB(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskSizeGiB = mapped
    }

    /**
     * @param value The storage type for the disk (i.e. Standard, Premium).
     */
    @JvmName("orovsrrsovoxmxme")
    public suspend fun diskType(`value`: Either<String, StorageType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskType = mapped
    }

    /**
     * @param value The storage type for the disk (i.e. Standard, Premium).
     */
    @JvmName("cbinycggccyaybcc")
    public fun diskType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, StorageType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.diskType = mapped
    }

    /**
     * @param value The storage type for the disk (i.e. Standard, Premium).
     */
    @JvmName("kpieyxqmsstmmnsl")
    public fun diskType(`value`: StorageType) {
        val toBeMapped = Either.ofRight<String, StorageType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.diskType = mapped
    }

    internal fun build(): AttachNewDataDiskOptionsArgs = AttachNewDataDiskOptionsArgs(
        diskName = diskName,
        diskSizeGiB = diskSizeGiB,
        diskType = diskType,
    )
}
