@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.inputs

import com.pulumi.azurenative.devtestlab.inputs.BulkCreationParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Parameters for creating multiple virtual machines as a single action.
 * @property instanceCount The number of virtual machine instances to create.
 */
public data class BulkCreationParametersArgs(
    public val instanceCount: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devtestlab.inputs.BulkCreationParametersArgs> {
    override fun toJava(): com.pulumi.azurenative.devtestlab.inputs.BulkCreationParametersArgs =
        com.pulumi.azurenative.devtestlab.inputs.BulkCreationParametersArgs.builder()
            .instanceCount(instanceCount?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BulkCreationParametersArgs].
 */
@PulumiTagMarker
public class BulkCreationParametersArgsBuilder internal constructor() {
    private var instanceCount: Output<Int>? = null

    /**
     * @param value The number of virtual machine instances to create.
     */
    @JvmName("jeghmgyweqhpdnqy")
    public suspend fun instanceCount(`value`: Output<Int>) {
        this.instanceCount = value
    }

    /**
     * @param value The number of virtual machine instances to create.
     */
    @JvmName("qvbgxgqusedcvtxc")
    public suspend fun instanceCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceCount = mapped
    }

    internal fun build(): BulkCreationParametersArgs = BulkCreationParametersArgs(
        instanceCount = instanceCount,
    )
}
