@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.inputs

import com.pulumi.azurenative.devtestlab.inputs.EventArgs.builder
import com.pulumi.azurenative.devtestlab.kotlin.enums.NotificationChannelEventType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * An event to be notified for.
 * @property eventName The event type for which this notification is enabled (i.e. AutoShutdown, Cost)
 */
public data class EventArgs(
    public val eventName: Output<Either<String, NotificationChannelEventType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devtestlab.inputs.EventArgs> {
    override fun toJava(): com.pulumi.azurenative.devtestlab.inputs.EventArgs =
        com.pulumi.azurenative.devtestlab.inputs.EventArgs.builder()
            .eventName(
                eventName?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [EventArgs].
 */
@PulumiTagMarker
public class EventArgsBuilder internal constructor() {
    private var eventName: Output<Either<String, NotificationChannelEventType>>? = null

    /**
     * @param value The event type for which this notification is enabled (i.e. AutoShutdown, Cost)
     */
    @JvmName("ystrynismbxcbttt")
    public suspend fun eventName(`value`: Output<Either<String, NotificationChannelEventType>>) {
        this.eventName = value
    }

    /**
     * @param value The event type for which this notification is enabled (i.e. AutoShutdown, Cost)
     */
    @JvmName("ovjyoychcoqiyilu")
    public suspend fun eventName(`value`: Either<String, NotificationChannelEventType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventName = mapped
    }

    /**
     * @param value The event type for which this notification is enabled (i.e. AutoShutdown, Cost)
     */
    @JvmName("clnxamjcpdcjmhil")
    public fun eventName(`value`: String) {
        val toBeMapped = Either.ofLeft<String, NotificationChannelEventType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.eventName = mapped
    }

    /**
     * @param value The event type for which this notification is enabled (i.e. AutoShutdown, Cost)
     */
    @JvmName("rwnlnrallsqbcuhe")
    public fun eventName(`value`: NotificationChannelEventType) {
        val toBeMapped = Either.ofRight<String, NotificationChannelEventType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.eventName = mapped
    }

    internal fun build(): EventArgs = EventArgs(
        eventName = eventName,
    )
}
