@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.inputs

import com.pulumi.azurenative.devtestlab.inputs.GetLabPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property expand Specify the $expand query. Example: 'properties($select=defaultStorageAccount)'
 * @property name The name of the lab.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetLabPlainArgs(
    public val expand: String? = null,
    public val name: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.devtestlab.inputs.GetLabPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.devtestlab.inputs.GetLabPlainArgs =
        com.pulumi.azurenative.devtestlab.inputs.GetLabPlainArgs.builder()
            .expand(expand?.let({ args0 -> args0 }))
            .name(name.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetLabPlainArgs].
 */
@PulumiTagMarker
public class GetLabPlainArgsBuilder internal constructor() {
    private var expand: String? = null

    private var name: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Specify the $expand query. Example: 'properties($select=defaultStorageAccount)'
     */
    @JvmName("fqhcdwdkanwtmebp")
    public suspend fun expand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.expand = mapped
    }

    /**
     * @param value The name of the lab.
     */
    @JvmName("pybqdwvcyutprtdj")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("mkhahrevatelruhc")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetLabPlainArgs = GetLabPlainArgs(
        expand = expand,
        name = name ?: throw PulumiNullFieldException("name"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
