@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.inputs

import com.pulumi.azurenative.devtestlab.inputs.GetServiceFabricSchedulePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property expand Specify the $expand query. Example: 'properties($select=status)'
 * @property labName The name of the lab.
 * @property name The name of the schedule.
 * @property resourceGroupName The name of the resource group.
 * @property serviceFabricName The name of the service fabric.
 * @property userName The name of the user profile.
 */
public data class GetServiceFabricSchedulePlainArgs(
    public val expand: String? = null,
    public val labName: String,
    public val name: String,
    public val resourceGroupName: String,
    public val serviceFabricName: String,
    public val userName: String,
) : ConvertibleToJava<com.pulumi.azurenative.devtestlab.inputs.GetServiceFabricSchedulePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.devtestlab.inputs.GetServiceFabricSchedulePlainArgs = com.pulumi.azurenative.devtestlab.inputs.GetServiceFabricSchedulePlainArgs.builder()
        .expand(expand?.let({ args0 -> args0 }))
        .labName(labName.let({ args0 -> args0 }))
        .name(name.let({ args0 -> args0 }))
        .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
        .serviceFabricName(serviceFabricName.let({ args0 -> args0 }))
        .userName(userName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetServiceFabricSchedulePlainArgs].
 */
@PulumiTagMarker
public class GetServiceFabricSchedulePlainArgsBuilder internal constructor() {
    private var expand: String? = null

    private var labName: String? = null

    private var name: String? = null

    private var resourceGroupName: String? = null

    private var serviceFabricName: String? = null

    private var userName: String? = null

    /**
     * @param value Specify the $expand query. Example: 'properties($select=status)'
     */
    @JvmName("apakhyhihaaimrob")
    public suspend fun expand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.expand = mapped
    }

    /**
     * @param value The name of the lab.
     */
    @JvmName("lrygffoohuckqheo")
    public suspend fun labName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.labName = mapped
    }

    /**
     * @param value The name of the schedule.
     */
    @JvmName("wktadwbubgsenxxh")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("nskltshvpjtnlkmv")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the service fabric.
     */
    @JvmName("wrelphvbeoctlhiq")
    public suspend fun serviceFabricName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceFabricName = mapped
    }

    /**
     * @param value The name of the user profile.
     */
    @JvmName("oqywhyoircfdebon")
    public suspend fun userName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.userName = mapped
    }

    internal fun build(): GetServiceFabricSchedulePlainArgs = GetServiceFabricSchedulePlainArgs(
        expand = expand,
        labName = labName ?: throw PulumiNullFieldException("labName"),
        name = name ?: throw PulumiNullFieldException("name"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serviceFabricName = serviceFabricName ?: throw PulumiNullFieldException("serviceFabricName"),
        userName = userName ?: throw PulumiNullFieldException("userName"),
    )
}
