@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.inputs

import com.pulumi.azurenative.devtestlab.inputs.LabAnnouncementPropertiesArgs.builder
import com.pulumi.azurenative.devtestlab.kotlin.enums.EnableStatus
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Properties of a lab's announcement banner
 * @property enabled Is the lab announcement active/enabled at this time?
 * @property expirationDate The time at which the announcement expires (null for never)
 * @property expired Has this announcement expired?
 * @property markdown The markdown text (if any) that this lab displays in the UI. If left empty/null, nothing will be shown.
 * @property title The plain text title for the lab announcement
 */
public data class LabAnnouncementPropertiesArgs(
    public val enabled: Output<Either<String, EnableStatus>>? = null,
    public val expirationDate: Output<String>? = null,
    public val expired: Output<Boolean>? = null,
    public val markdown: Output<String>? = null,
    public val title: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devtestlab.inputs.LabAnnouncementPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.devtestlab.inputs.LabAnnouncementPropertiesArgs =
        com.pulumi.azurenative.devtestlab.inputs.LabAnnouncementPropertiesArgs.builder()
            .enabled(
                enabled?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .expirationDate(expirationDate?.applyValue({ args0 -> args0 }))
            .expired(expired?.applyValue({ args0 -> args0 }))
            .markdown(markdown?.applyValue({ args0 -> args0 }))
            .title(title?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LabAnnouncementPropertiesArgs].
 */
@PulumiTagMarker
public class LabAnnouncementPropertiesArgsBuilder internal constructor() {
    private var enabled: Output<Either<String, EnableStatus>>? = null

    private var expirationDate: Output<String>? = null

    private var expired: Output<Boolean>? = null

    private var markdown: Output<String>? = null

    private var title: Output<String>? = null

    /**
     * @param value Is the lab announcement active/enabled at this time?
     */
    @JvmName("giyknnxntmoqxgnx")
    public suspend fun enabled(`value`: Output<Either<String, EnableStatus>>) {
        this.enabled = value
    }

    /**
     * @param value The time at which the announcement expires (null for never)
     */
    @JvmName("lafgbffiddgwjssd")
    public suspend fun expirationDate(`value`: Output<String>) {
        this.expirationDate = value
    }

    /**
     * @param value Has this announcement expired?
     */
    @JvmName("bbnqmomydpvdfxao")
    public suspend fun expired(`value`: Output<Boolean>) {
        this.expired = value
    }

    /**
     * @param value The markdown text (if any) that this lab displays in the UI. If left empty/null, nothing will be shown.
     */
    @JvmName("gpibojyxglobehdk")
    public suspend fun markdown(`value`: Output<String>) {
        this.markdown = value
    }

    /**
     * @param value The plain text title for the lab announcement
     */
    @JvmName("oaphvsnyxvkdfqdu")
    public suspend fun title(`value`: Output<String>) {
        this.title = value
    }

    /**
     * @param value Is the lab announcement active/enabled at this time?
     */
    @JvmName("bmtatcwswrwweiha")
    public suspend fun enabled(`value`: Either<String, EnableStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Is the lab announcement active/enabled at this time?
     */
    @JvmName("rbxdvbuyyiddckmd")
    public fun enabled(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EnableStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Is the lab announcement active/enabled at this time?
     */
    @JvmName("oadjmuhkbsphoikv")
    public fun enabled(`value`: EnableStatus) {
        val toBeMapped = Either.ofRight<String, EnableStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value The time at which the announcement expires (null for never)
     */
    @JvmName("dpttjxnrthwxcxuh")
    public suspend fun expirationDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expirationDate = mapped
    }

    /**
     * @param value Has this announcement expired?
     */
    @JvmName("pvdmhwlsjrmulavq")
    public suspend fun expired(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expired = mapped
    }

    /**
     * @param value The markdown text (if any) that this lab displays in the UI. If left empty/null, nothing will be shown.
     */
    @JvmName("xhtejmpiljmnckex")
    public suspend fun markdown(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.markdown = mapped
    }

    /**
     * @param value The plain text title for the lab announcement
     */
    @JvmName("hjqkunuqhlgjqtrj")
    public suspend fun title(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.title = mapped
    }

    internal fun build(): LabAnnouncementPropertiesArgs = LabAnnouncementPropertiesArgs(
        enabled = enabled,
        expirationDate = expirationDate,
        expired = expired,
        markdown = markdown,
        title = title,
    )
}
