@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.inputs

import com.pulumi.azurenative.devtestlab.inputs.LinuxOsInfoArgs.builder
import com.pulumi.azurenative.devtestlab.kotlin.enums.LinuxOsState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Information about a Linux OS.
 * @property linuxOsState The state of the Linux OS (i.e. NonDeprovisioned, DeprovisionRequested, DeprovisionApplied).
 */
public data class LinuxOsInfoArgs(
    public val linuxOsState: Output<Either<String, LinuxOsState>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devtestlab.inputs.LinuxOsInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.devtestlab.inputs.LinuxOsInfoArgs =
        com.pulumi.azurenative.devtestlab.inputs.LinuxOsInfoArgs.builder()
            .linuxOsState(
                linuxOsState?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [LinuxOsInfoArgs].
 */
@PulumiTagMarker
public class LinuxOsInfoArgsBuilder internal constructor() {
    private var linuxOsState: Output<Either<String, LinuxOsState>>? = null

    /**
     * @param value The state of the Linux OS (i.e. NonDeprovisioned, DeprovisionRequested, DeprovisionApplied).
     */
    @JvmName("pxfyeljgvstahuha")
    public suspend fun linuxOsState(`value`: Output<Either<String, LinuxOsState>>) {
        this.linuxOsState = value
    }

    /**
     * @param value The state of the Linux OS (i.e. NonDeprovisioned, DeprovisionRequested, DeprovisionApplied).
     */
    @JvmName("tuxsqqiregkgpkdl")
    public suspend fun linuxOsState(`value`: Either<String, LinuxOsState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linuxOsState = mapped
    }

    /**
     * @param value The state of the Linux OS (i.e. NonDeprovisioned, DeprovisionRequested, DeprovisionApplied).
     */
    @JvmName("yvpwobywhkhyeyqt")
    public fun linuxOsState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, LinuxOsState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.linuxOsState = mapped
    }

    /**
     * @param value The state of the Linux OS (i.e. NonDeprovisioned, DeprovisionRequested, DeprovisionApplied).
     */
    @JvmName("kdbhbuhepegglrgk")
    public fun linuxOsState(`value`: LinuxOsState) {
        val toBeMapped = Either.ofRight<String, LinuxOsState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.linuxOsState = mapped
    }

    internal fun build(): LinuxOsInfoArgs = LinuxOsInfoArgs(
        linuxOsState = linuxOsState,
    )
}
