@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.inputs

import com.pulumi.azurenative.devtestlab.inputs.ListScheduleApplicablePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property labName The name of the lab.
 * @property name The name of the schedule.
 * @property resourceGroupName The name of the resource group.
 */
public data class ListScheduleApplicablePlainArgs(
    public val labName: String,
    public val name: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.devtestlab.inputs.ListScheduleApplicablePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.devtestlab.inputs.ListScheduleApplicablePlainArgs =
        com.pulumi.azurenative.devtestlab.inputs.ListScheduleApplicablePlainArgs.builder()
            .labName(labName.let({ args0 -> args0 }))
            .name(name.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListScheduleApplicablePlainArgs].
 */
@PulumiTagMarker
public class ListScheduleApplicablePlainArgsBuilder internal constructor() {
    private var labName: String? = null

    private var name: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the lab.
     */
    @JvmName("gsbjmsxovwvjgyrg")
    public suspend fun labName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.labName = mapped
    }

    /**
     * @param value The name of the schedule.
     */
    @JvmName("pfdxrvclegnqgtre")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("dkyerfgcjfgdtbie")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): ListScheduleApplicablePlainArgs = ListScheduleApplicablePlainArgs(
        labName = labName ?: throw PulumiNullFieldException("labName"),
        name = name ?: throw PulumiNullFieldException("name"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
