@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Properties of an Azure Resource Manager template parameter.
 * @property name The name of the template parameter.
 * @property value The value of the template parameter.
 */
public data class ArmTemplateParameterPropertiesResponse(
    public val name: String? = null,
    public val `value`: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devtestlab.outputs.ArmTemplateParameterPropertiesResponse): ArmTemplateParameterPropertiesResponse = ArmTemplateParameterPropertiesResponse(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
        )
    }
}
