@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Properties of an artifact deployment.
 * @property artifactsApplied The total count of the artifacts that were successfully applied.
 * @property deploymentStatus The deployment status of the artifact.
 * @property totalArtifacts The total count of the artifacts that were tentatively applied.
 */
public data class ArtifactDeploymentStatusPropertiesResponse(
    public val artifactsApplied: Int? = null,
    public val deploymentStatus: String? = null,
    public val totalArtifacts: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devtestlab.outputs.ArtifactDeploymentStatusPropertiesResponse): ArtifactDeploymentStatusPropertiesResponse = ArtifactDeploymentStatusPropertiesResponse(
            artifactsApplied = javaType.artifactsApplied().map({ args0 -> args0 }).orElse(null),
            deploymentStatus = javaType.deploymentStatus().map({ args0 -> args0 }).orElse(null),
            totalArtifacts = javaType.totalArtifacts().map({ args0 -> args0 }).orElse(null),
        )
    }
}
