@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Properties to attach new disk to the Virtual Machine.
 * @property diskName The name of the disk to be attached.
 * @property diskSizeGiB Size of the disk to be attached in Gibibytes.
 * @property diskType The storage type for the disk (i.e. Standard, Premium).
 */
public data class AttachNewDataDiskOptionsResponse(
    public val diskName: String? = null,
    public val diskSizeGiB: Int? = null,
    public val diskType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devtestlab.outputs.AttachNewDataDiskOptionsResponse): AttachNewDataDiskOptionsResponse = AttachNewDataDiskOptionsResponse(
            diskName = javaType.diskName().map({ args0 -> args0 }).orElse(null),
            diskSizeGiB = javaType.diskSizeGiB().map({ args0 -> args0 }).orElse(null),
            diskType = javaType.diskType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
