@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 * Parameters for creating multiple virtual machines as a single action.
 * @property instanceCount The number of virtual machine instances to create.
 */
public data class BulkCreationParametersResponse(
    public val instanceCount: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devtestlab.outputs.BulkCreationParametersResponse): BulkCreationParametersResponse = BulkCreationParametersResponse(
            instanceCount = javaType.instanceCount().map({ args0 -> args0 }).orElse(null),
        )
    }
}
