@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * A data disks attached to a virtual machine.
 * @property diskSizeGiB Gets data disk size in GiB.
 * @property diskUri When backed by a blob, the URI of underlying blob.
 * @property managedDiskId When backed by managed disk, this is the ID of the compute disk resource.
 * @property name Gets data disk name.
 */
public data class ComputeDataDiskResponse(
    public val diskSizeGiB: Int? = null,
    public val diskUri: String? = null,
    public val managedDiskId: String? = null,
    public val name: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devtestlab.outputs.ComputeDataDiskResponse): ComputeDataDiskResponse = ComputeDataDiskResponse(
            diskSizeGiB = javaType.diskSizeGiB().map({ args0 -> args0 }).orElse(null),
            diskUri = javaType.diskUri().map({ args0 -> args0 }).orElse(null),
            managedDiskId = javaType.managedDiskId().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
        )
    }
}
