@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Status information about a virtual machine.
 * @property code Gets the status Code.
 * @property displayStatus Gets the short localizable label for the status.
 * @property message Gets the message associated with the status.
 */
public data class ComputeVmInstanceViewStatusResponse(
    public val code: String? = null,
    public val displayStatus: String? = null,
    public val message: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devtestlab.outputs.ComputeVmInstanceViewStatusResponse): ComputeVmInstanceViewStatusResponse = ComputeVmInstanceViewStatusResponse(
            code = javaType.code().map({ args0 -> args0 }).orElse(null),
            displayStatus = javaType.displayStatus().map({ args0 -> args0 }).orElse(null),
            message = javaType.message().map({ args0 -> args0 }).orElse(null),
        )
    }
}
