@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Properties for plan on a custom image.
 * @property id The id of the plan, equivalent to name of the plan
 * @property offer The offer for the plan from the marketplace image the custom image is derived from
 * @property publisher The publisher for the plan from the marketplace image the custom image is derived from
 */
public data class CustomImagePropertiesFromPlanResponse(
    public val id: String? = null,
    public val offer: String? = null,
    public val publisher: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devtestlab.outputs.CustomImagePropertiesFromPlanResponse): CustomImagePropertiesFromPlanResponse = CustomImagePropertiesFromPlanResponse(
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            offer = javaType.offer().map({ args0 -> args0 }).orElse(null),
            publisher = javaType.publisher().map({ args0 -> args0 }).orElse(null),
        )
    }
}
