@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Request body for adding a new or existing data disk to a virtual machine.
 * @property attachNewDataDiskOptions Specifies options to attach a new disk to the virtual machine.
 * @property existingLabDiskId Specifies the existing lab disk id to attach to virtual machine.
 * @property hostCaching Caching option for a data disk (i.e. None, ReadOnly, ReadWrite).
 */
public data class DataDiskPropertiesResponse(
    public val attachNewDataDiskOptions: AttachNewDataDiskOptionsResponse? = null,
    public val existingLabDiskId: String? = null,
    public val hostCaching: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devtestlab.outputs.DataDiskPropertiesResponse): DataDiskPropertiesResponse = DataDiskPropertiesResponse(
            attachNewDataDiskOptions = javaType.attachNewDataDiskOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devtestlab.kotlin.outputs.AttachNewDataDiskOptionsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            existingLabDiskId = javaType.existingLabDiskId().map({ args0 -> args0 }).orElse(null),
            hostCaching = javaType.hostCaching().map({ args0 -> args0 }).orElse(null),
        )
    }
}
