@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Properties of an environment deployment.
 * @property armTemplateId The Azure Resource Manager template's identifier.
 * @property parameters The parameters of the Azure Resource Manager template.
 */
public data class EnvironmentDeploymentPropertiesResponse(
    public val armTemplateId: String? = null,
    public val parameters: List<ArmTemplateParameterPropertiesResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devtestlab.outputs.EnvironmentDeploymentPropertiesResponse): EnvironmentDeploymentPropertiesResponse = EnvironmentDeploymentPropertiesResponse(
            armTemplateId = javaType.armTemplateId().map({ args0 -> args0 }).orElse(null),
            parameters = javaType.parameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devtestlab.kotlin.outputs.ArmTemplateParameterPropertiesResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
