@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A Disk.
 * @property createdDate The creation date of the disk.
 * @property diskBlobName When backed by a blob, the name of the VHD blob without extension.
 * @property diskSizeGiB The size of the disk in Gibibytes.
 * @property diskType The storage type for the disk (i.e. Standard, Premium).
 * @property diskUri When backed by a blob, the URI of underlying blob.
 * @property hostCaching The host caching policy of the disk (i.e. None, ReadOnly, ReadWrite).
 * @property id The identifier of the resource.
 * @property leasedByLabVmId The resource ID of the VM to which this disk is leased.
 * @property location The location of the resource.
 * @property managedDiskId When backed by managed disk, this is the ID of the compute disk resource.
 * @property name The name of the resource.
 * @property provisioningState The provisioning status of the resource.
 * @property storageAccountId When backed by a blob, the storage account where the blob is.
 * @property tags The tags of the resource.
 * @property type The type of the resource.
 * @property uniqueIdentifier The unique immutable identifier of a resource (Guid).
 */
public data class GetDiskResult(
    public val createdDate: String,
    public val diskBlobName: String? = null,
    public val diskSizeGiB: Int? = null,
    public val diskType: String? = null,
    public val diskUri: String? = null,
    public val hostCaching: String? = null,
    public val id: String,
    public val leasedByLabVmId: String? = null,
    public val location: String? = null,
    public val managedDiskId: String? = null,
    public val name: String,
    public val provisioningState: String,
    public val storageAccountId: String? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val uniqueIdentifier: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devtestlab.outputs.GetDiskResult): GetDiskResult = GetDiskResult(
            createdDate = javaType.createdDate(),
            diskBlobName = javaType.diskBlobName().map({ args0 -> args0 }).orElse(null),
            diskSizeGiB = javaType.diskSizeGiB().map({ args0 -> args0 }).orElse(null),
            diskType = javaType.diskType().map({ args0 -> args0 }).orElse(null),
            diskUri = javaType.diskUri().map({ args0 -> args0 }).orElse(null),
            hostCaching = javaType.hostCaching().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            leasedByLabVmId = javaType.leasedByLabVmId().map({ args0 -> args0 }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            managedDiskId = javaType.managedDiskId().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            storageAccountId = javaType.storageAccountId().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            uniqueIdentifier = javaType.uniqueIdentifier(),
        )
    }
}
