@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A formula for creating a VM, specifying an image base and other parameters
 * @property author The author of the formula.
 * @property creationDate The creation date of the formula.
 * @property description The description of the formula.
 * @property formulaContent The content of the formula.
 * @property id The identifier of the resource.
 * @property location The location of the resource.
 * @property name The name of the resource.
 * @property osType The OS type of the formula.
 * @property provisioningState The provisioning status of the resource.
 * @property tags The tags of the resource.
 * @property type The type of the resource.
 * @property uniqueIdentifier The unique immutable identifier of a resource (Guid).
 * @property vm Information about a VM from which a formula is to be created.
 */
public data class GetFormulaResult(
    public val author: String,
    public val creationDate: String,
    public val description: String? = null,
    public val formulaContent: LabVirtualMachineCreationParameterResponse? = null,
    public val id: String,
    public val location: String? = null,
    public val name: String,
    public val osType: String? = null,
    public val provisioningState: String,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val uniqueIdentifier: String,
    public val vm: FormulaPropertiesFromVmResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devtestlab.outputs.GetFormulaResult): GetFormulaResult = GetFormulaResult(
            author = javaType.author(),
            creationDate = javaType.creationDate(),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            formulaContent = javaType.formulaContent().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devtestlab.kotlin.outputs.LabVirtualMachineCreationParameterResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            osType = javaType.osType().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            uniqueIdentifier = javaType.uniqueIdentifier(),
            vm = javaType.vm().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devtestlab.kotlin.outputs.FormulaPropertiesFromVmResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
