@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A Policy.
 * @property createdDate The creation date of the policy.
 * @property description The description of the policy.
 * @property evaluatorType The evaluator type of the policy (i.e. AllowedValuesPolicy, MaxValuePolicy).
 * @property factData The fact data of the policy.
 * @property factName The fact name of the policy (e.g. LabVmCount, LabVmSize, MaxVmsAllowedPerLab, etc.
 * @property id The identifier of the resource.
 * @property location The location of the resource.
 * @property name The name of the resource.
 * @property provisioningState The provisioning status of the resource.
 * @property status The status of the policy.
 * @property tags The tags of the resource.
 * @property threshold The threshold of the policy (i.e. a number for MaxValuePolicy, and a JSON array of values for AllowedValuesPolicy).
 * @property type The type of the resource.
 * @property uniqueIdentifier The unique immutable identifier of a resource (Guid).
 */
public data class GetPolicyResult(
    public val createdDate: String,
    public val description: String? = null,
    public val evaluatorType: String? = null,
    public val factData: String? = null,
    public val factName: String? = null,
    public val id: String,
    public val location: String? = null,
    public val name: String,
    public val provisioningState: String,
    public val status: String? = null,
    public val tags: Map<String, String>? = null,
    public val threshold: String? = null,
    public val type: String,
    public val uniqueIdentifier: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devtestlab.outputs.GetPolicyResult): GetPolicyResult = GetPolicyResult(
            createdDate = javaType.createdDate(),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            evaluatorType = javaType.evaluatorType().map({ args0 -> args0 }).orElse(null),
            factData = javaType.factData().map({ args0 -> args0 }).orElse(null),
            factName = javaType.factName().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            threshold = javaType.threshold().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            uniqueIdentifier = javaType.uniqueIdentifier(),
        )
    }
}
