@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A Service Fabric.
 * @property applicableSchedule The applicable schedule for the virtual machine.
 * @property environmentId The resource id of the environment under which the service fabric resource is present
 * @property externalServiceFabricId The backing service fabric resource's id
 * @property id The identifier of the resource.
 * @property location The location of the resource.
 * @property name The name of the resource.
 * @property provisioningState The provisioning status of the resource.
 * @property tags The tags of the resource.
 * @property type The type of the resource.
 * @property uniqueIdentifier The unique immutable identifier of a resource (Guid).
 */
public data class GetServiceFabricResult(
    public val applicableSchedule: ApplicableScheduleResponse,
    public val environmentId: String? = null,
    public val externalServiceFabricId: String? = null,
    public val id: String,
    public val location: String? = null,
    public val name: String,
    public val provisioningState: String,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val uniqueIdentifier: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devtestlab.outputs.GetServiceFabricResult): GetServiceFabricResult = GetServiceFabricResult(
            applicableSchedule = javaType.applicableSchedule().let({ args0 ->
                com.pulumi.azurenative.devtestlab.kotlin.outputs.ApplicableScheduleResponse.Companion.toKotlin(args0)
            }),
            environmentId = javaType.environmentId().map({ args0 -> args0 }).orElse(null),
            externalServiceFabricId = javaType.externalServiceFabricId().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            uniqueIdentifier = javaType.uniqueIdentifier(),
        )
    }
}
