@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Profile of a lab user.
 * @property createdDate The creation date of the user profile.
 * @property id The identifier of the resource.
 * @property identity The identity of the user.
 * @property location The location of the resource.
 * @property name The name of the resource.
 * @property provisioningState The provisioning status of the resource.
 * @property secretStore The secret store of the user.
 * @property tags The tags of the resource.
 * @property type The type of the resource.
 * @property uniqueIdentifier The unique immutable identifier of a resource (Guid).
 */
public data class GetUserResult(
    public val createdDate: String,
    public val id: String,
    public val identity: UserIdentityResponse? = null,
    public val location: String? = null,
    public val name: String,
    public val provisioningState: String,
    public val secretStore: UserSecretStoreResponse? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val uniqueIdentifier: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devtestlab.outputs.GetUserResult): GetUserResult = GetUserResult(
            createdDate = javaType.createdDate(),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devtestlab.kotlin.outputs.UserIdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            secretStore = javaType.secretStore().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devtestlab.kotlin.outputs.UserSecretStoreResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            uniqueIdentifier = javaType.uniqueIdentifier(),
        )
    }
}
