@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Properties of a managed identity
 * @property clientSecretUrl The client secret URL of the identity.
 * @property principalId The principal id of resource identity.
 * @property tenantId The tenant identifier of resource.
 * @property type Managed identity.
 */
public data class IdentityPropertiesResponse(
    public val clientSecretUrl: String? = null,
    public val principalId: String? = null,
    public val tenantId: String? = null,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devtestlab.outputs.IdentityPropertiesResponse): IdentityPropertiesResponse = IdentityPropertiesResponse(
            clientSecretUrl = javaType.clientSecretUrl().map({ args0 -> args0 }).orElse(null),
            principalId = javaType.principalId().map({ args0 -> args0 }).orElse(null),
            tenantId = javaType.tenantId().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
