@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Properties of a lab's announcement banner
 * @property enabled Is the lab announcement active/enabled at this time?
 * @property expirationDate The time at which the announcement expires (null for never)
 * @property expired Has this announcement expired?
 * @property markdown The markdown text (if any) that this lab displays in the UI. If left empty/null, nothing will be shown.
 * @property provisioningState The provisioning status of the resource.
 * @property title The plain text title for the lab announcement
 * @property uniqueIdentifier The unique immutable identifier of a resource (Guid).
 */
public data class LabAnnouncementPropertiesResponse(
    public val enabled: String? = null,
    public val expirationDate: String? = null,
    public val expired: Boolean? = null,
    public val markdown: String? = null,
    public val provisioningState: String,
    public val title: String? = null,
    public val uniqueIdentifier: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devtestlab.outputs.LabAnnouncementPropertiesResponse): LabAnnouncementPropertiesResponse = LabAnnouncementPropertiesResponse(
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            expirationDate = javaType.expirationDate().map({ args0 -> args0 }).orElse(null),
            expired = javaType.expired().map({ args0 -> args0 }).orElse(null),
            markdown = javaType.markdown().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            title = javaType.title().map({ args0 -> args0 }).orElse(null),
            uniqueIdentifier = javaType.uniqueIdentifier(),
        )
    }
}
