@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Information about a Linux OS.
 * @property linuxOsState The state of the Linux OS (i.e. NonDeprovisioned, DeprovisionRequested, DeprovisionApplied).
 */
public data class LinuxOsInfoResponse(
    public val linuxOsState: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devtestlab.outputs.LinuxOsInfoResponse): LinuxOsInfoResponse = LinuxOsInfoResponse(
            linuxOsState = javaType.linuxOsState().map({ args0 -> args0 }).orElse(null),
        )
    }
}
