@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The response of a list operation.
 * @property nextLink Link for next set of results.
 * @property value Results of the list operation.
 */
public data class ListLabVhdsResult(
    public val nextLink: String? = null,
    public val `value`: List<LabVhdResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devtestlab.outputs.ListLabVhdsResult): ListLabVhdsResult = ListLabVhdsResult(
            nextLink = javaType.nextLink().map({ args0 -> args0 }).orElse(null),
            `value` = javaType.`value`().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devtestlab.kotlin.outputs.LabVhdResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
