@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Properties for creating a schedule.
 * @property dailyRecurrence If the schedule will occur once each day of the week, specify the daily recurrence.
 * @property hourlyRecurrence If the schedule will occur multiple times a day, specify the hourly recurrence.
 * @property location The location of the new virtual machine or environment
 * @property name The name of the virtual machine or environment
 * @property notificationSettings Notification settings.
 * @property status The status of the schedule (i.e. Enabled, Disabled)
 * @property tags The tags of the resource.
 * @property targetResourceId The resource ID to which the schedule belongs
 * @property taskType The task type of the schedule (e.g. LabVmsShutdownTask, LabVmAutoStart).
 * @property timeZoneId The time zone ID (e.g. China Standard Time, Greenland Standard Time, Pacific Standard time, etc.). The possible values for this property can be found in `IReadOnlyCollection<string> TimeZoneConverter.TZConvert.KnownWindowsTimeZoneIds` (https://github.com/mattjohnsonpint/TimeZoneConverter/blob/main/README.md)
 * @property weeklyRecurrence If the schedule will occur only some days of the week, specify the weekly recurrence.
 */
public data class ScheduleCreationParameterResponse(
    public val dailyRecurrence: DayDetailsResponse? = null,
    public val hourlyRecurrence: HourDetailsResponse? = null,
    public val location: String,
    public val name: String? = null,
    public val notificationSettings: NotificationSettingsResponse? = null,
    public val status: String? = null,
    public val tags: Map<String, String>? = null,
    public val targetResourceId: String? = null,
    public val taskType: String? = null,
    public val timeZoneId: String? = null,
    public val weeklyRecurrence: WeekDetailsResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devtestlab.outputs.ScheduleCreationParameterResponse): ScheduleCreationParameterResponse = ScheduleCreationParameterResponse(
            dailyRecurrence = javaType.dailyRecurrence().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devtestlab.kotlin.outputs.DayDetailsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            hourlyRecurrence = javaType.hourlyRecurrence().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devtestlab.kotlin.outputs.HourDetailsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location(),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            notificationSettings = javaType.notificationSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devtestlab.kotlin.outputs.NotificationSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            targetResourceId = javaType.targetResourceId().map({ args0 -> args0 }).orElse(null),
            taskType = javaType.taskType().map({ args0 -> args0 }).orElse(null),
            timeZoneId = javaType.timeZoneId().map({ args0 -> args0 }).orElse(null),
            weeklyRecurrence = javaType.weeklyRecurrence().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devtestlab.kotlin.outputs.WeekDetailsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
