@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * Properties of a virtual machine that determine how it is connected to a load balancer.
 * @property inboundNatRules The incoming NAT rules
 */
public data class SharedPublicIpAddressConfigurationResponse(
    public val inboundNatRules: List<InboundNatRuleResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devtestlab.outputs.SharedPublicIpAddressConfigurationResponse): SharedPublicIpAddressConfigurationResponse = SharedPublicIpAddressConfigurationResponse(
            inboundNatRules = javaType.inboundNatRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devtestlab.kotlin.outputs.InboundNatRuleResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
