@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Property overrides on a subnet of a virtual network.
 * @property labSubnetName The name given to the subnet within the lab.
 * @property resourceId The resource ID of the subnet.
 * @property sharedPublicIpAddressConfiguration Properties that virtual machines on this subnet will share.
 * @property useInVmCreationPermission Indicates whether this subnet can be used during virtual machine creation (i.e. Allow, Deny).
 * @property usePublicIpAddressPermission Indicates whether public IP addresses can be assigned to virtual machines on this subnet (i.e. Allow, Deny).
 * @property virtualNetworkPoolName The virtual network pool associated with this subnet.
 */
public data class SubnetOverrideResponse(
    public val labSubnetName: String? = null,
    public val resourceId: String? = null,
    public val sharedPublicIpAddressConfiguration: SubnetSharedPublicIpAddressConfigurationResponse? =
        null,
    public val useInVmCreationPermission: String? = null,
    public val usePublicIpAddressPermission: String? = null,
    public val virtualNetworkPoolName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devtestlab.outputs.SubnetOverrideResponse): SubnetOverrideResponse = SubnetOverrideResponse(
            labSubnetName = javaType.labSubnetName().map({ args0 -> args0 }).orElse(null),
            resourceId = javaType.resourceId().map({ args0 -> args0 }).orElse(null),
            sharedPublicIpAddressConfiguration = javaType.sharedPublicIpAddressConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devtestlab.kotlin.outputs.SubnetSharedPublicIpAddressConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            useInVmCreationPermission = javaType.useInVmCreationPermission().map({ args0 ->
                args0
            }).orElse(null),
            usePublicIpAddressPermission = javaType.usePublicIpAddressPermission().map({ args0 ->
                args0
            }).orElse(null),
            virtualNetworkPoolName = javaType.virtualNetworkPoolName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
