@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Information about a Windows OS.
 * @property windowsOsState The state of the Windows OS (i.e. NonSysprepped, SysprepRequested, SysprepApplied).
 */
public data class WindowsOsInfoResponse(
    public val windowsOsState: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devtestlab.outputs.WindowsOsInfoResponse): WindowsOsInfoResponse = WindowsOsInfoResponse(
            windowsOsState = javaType.windowsOsState().map({ args0 -> args0 }).orElse(null),
        )
    }
}
