@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.digitaltwins.kotlin

import com.pulumi.azurenative.digitaltwins.kotlin.outputs.DigitalTwinsIdentityResponse
import com.pulumi.azurenative.digitaltwins.kotlin.outputs.PrivateEndpointConnectionResponse
import com.pulumi.azurenative.digitaltwins.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.digitaltwins.kotlin.outputs.DigitalTwinsIdentityResponse.Companion.toKotlin as digitalTwinsIdentityResponseToKotlin
import com.pulumi.azurenative.digitaltwins.kotlin.outputs.PrivateEndpointConnectionResponse.Companion.toKotlin as privateEndpointConnectionResponseToKotlin
import com.pulumi.azurenative.digitaltwins.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [DigitalTwin].
 */
@PulumiTagMarker
public class DigitalTwinResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DigitalTwinArgs = DigitalTwinArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DigitalTwinArgsBuilder.() -> Unit) {
        val builder = DigitalTwinArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DigitalTwin {
        val builtJavaResource = com.pulumi.azurenative.digitaltwins.DigitalTwin(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DigitalTwin(builtJavaResource)
    }
}

/**
 * The description of the DigitalTwins service.
 * Azure REST API version: 2023-01-31. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2020-03-01-preview.
 * ## Example Usage
 * ### Put a DigitalTwinsInstance resource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var digitalTwin = new AzureNative.DigitalTwins.DigitalTwin("digitalTwin", new()
 *     {
 *         Location = "WestUS2",
 *         ResourceGroupName = "resRg",
 *         ResourceName = "myDigitalTwinsService",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/digitaltwins/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := digitaltwins.NewDigitalTwin(ctx, "digitalTwin", &digitaltwins.DigitalTwinArgs{
 * 			Location:          pulumi.String("WestUS2"),
 * 			ResourceGroupName: pulumi.String("resRg"),
 * 			ResourceName:      pulumi.String("myDigitalTwinsService"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.digitaltwins.DigitalTwin;
 * import com.pulumi.azurenative.digitaltwins.DigitalTwinArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var digitalTwin = new DigitalTwin("digitalTwin", DigitalTwinArgs.builder()
 *             .location("WestUS2")
 *             .resourceGroupName("resRg")
 *             .resourceName("myDigitalTwinsService")
 *             .build());
 *     }
 * }
 * ```
 * ### Put a DigitalTwinsInstance resource with publicNetworkAccess property
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var digitalTwin = new AzureNative.DigitalTwins.DigitalTwin("digitalTwin", new()
 *     {
 *         Location = "WestUS2",
 *         PublicNetworkAccess = AzureNative.DigitalTwins.PublicNetworkAccess.Enabled,
 *         ResourceGroupName = "resRg",
 *         ResourceName = "myDigitalTwinsService",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/digitaltwins/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := digitaltwins.NewDigitalTwin(ctx, "digitalTwin", &digitaltwins.DigitalTwinArgs{
 * 			Location:            pulumi.String("WestUS2"),
 * 			PublicNetworkAccess: pulumi.String(digitaltwins.PublicNetworkAccessEnabled),
 * 			ResourceGroupName:   pulumi.String("resRg"),
 * 			ResourceName:        pulumi.String("myDigitalTwinsService"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.digitaltwins.DigitalTwin;
 * import com.pulumi.azurenative.digitaltwins.DigitalTwinArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var digitalTwin = new DigitalTwin("digitalTwin", DigitalTwinArgs.builder()
 *             .location("WestUS2")
 *             .publicNetworkAccess("Enabled")
 *             .resourceGroupName("resRg")
 *             .resourceName("myDigitalTwinsService")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:digitaltwins:DigitalTwin myDigitalTwinsService /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DigitalTwins/digitalTwinsInstances/{resourceName}
 * ```
 */
public class DigitalTwin internal constructor(
    override val javaResource: com.pulumi.azurenative.digitaltwins.DigitalTwin,
) : KotlinCustomResource(javaResource, DigitalTwinMapper) {
    /**
     * Time when DigitalTwinsInstance was created.
     */
    public val createdTime: Output<String>
        get() = javaResource.createdTime().applyValue({ args0 -> args0 })

    /**
     * Api endpoint to work with DigitalTwinsInstance.
     */
    public val hostName: Output<String>
        get() = javaResource.hostName().applyValue({ args0 -> args0 })

    /**
     * The managed identity for the DigitalTwinsInstance.
     */
    public val identity: Output<DigitalTwinsIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    digitalTwinsIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Time when DigitalTwinsInstance was updated.
     */
    public val lastUpdatedTime: Output<String>
        get() = javaResource.lastUpdatedTime().applyValue({ args0 -> args0 })

    /**
     * The resource location.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The private endpoint connections.
     */
    public val privateEndpointConnections: Output<List<PrivateEndpointConnectionResponse>>?
        get() = javaResource.privateEndpointConnections().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        privateEndpointConnectionResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The provisioning state.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Public network access for the DigitalTwinsInstance.
     */
    public val publicNetworkAccess: Output<String>?
        get() = javaResource.publicNetworkAccess().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Metadata pertaining to creation and last modification of the DigitalTwinsInstance.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DigitalTwinMapper : ResourceMapper<DigitalTwin> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.digitaltwins.DigitalTwin::class == javaResource::class

    override fun map(javaResource: Resource): DigitalTwin = DigitalTwin(
        javaResource as
            com.pulumi.azurenative.digitaltwins.DigitalTwin,
    )
}

/**
 * @see [DigitalTwin].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DigitalTwin].
 */
public suspend fun digitalTwin(name: String, block: suspend DigitalTwinResourceBuilder.() -> Unit): DigitalTwin {
    val builder = DigitalTwinResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DigitalTwin].
 * @param name The _unique_ name of the resulting resource.
 */
public fun digitalTwin(name: String): DigitalTwin {
    val builder = DigitalTwinResourceBuilder()
    builder.name(name)
    return builder.build()
}
