@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.digitaltwins.kotlin

import com.pulumi.azurenative.digitaltwins.DigitaltwinsFunctions.getDigitalTwinPlain
import com.pulumi.azurenative.digitaltwins.DigitaltwinsFunctions.getDigitalTwinsEndpointPlain
import com.pulumi.azurenative.digitaltwins.DigitaltwinsFunctions.getPrivateEndpointConnectionPlain
import com.pulumi.azurenative.digitaltwins.DigitaltwinsFunctions.getTimeSeriesDatabaseConnectionPlain
import com.pulumi.azurenative.digitaltwins.kotlin.inputs.GetDigitalTwinPlainArgs
import com.pulumi.azurenative.digitaltwins.kotlin.inputs.GetDigitalTwinPlainArgsBuilder
import com.pulumi.azurenative.digitaltwins.kotlin.inputs.GetDigitalTwinsEndpointPlainArgs
import com.pulumi.azurenative.digitaltwins.kotlin.inputs.GetDigitalTwinsEndpointPlainArgsBuilder
import com.pulumi.azurenative.digitaltwins.kotlin.inputs.GetPrivateEndpointConnectionPlainArgs
import com.pulumi.azurenative.digitaltwins.kotlin.inputs.GetPrivateEndpointConnectionPlainArgsBuilder
import com.pulumi.azurenative.digitaltwins.kotlin.inputs.GetTimeSeriesDatabaseConnectionPlainArgs
import com.pulumi.azurenative.digitaltwins.kotlin.inputs.GetTimeSeriesDatabaseConnectionPlainArgsBuilder
import com.pulumi.azurenative.digitaltwins.kotlin.outputs.GetDigitalTwinResult
import com.pulumi.azurenative.digitaltwins.kotlin.outputs.GetDigitalTwinsEndpointResult
import com.pulumi.azurenative.digitaltwins.kotlin.outputs.GetPrivateEndpointConnectionResult
import com.pulumi.azurenative.digitaltwins.kotlin.outputs.GetTimeSeriesDatabaseConnectionResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.digitaltwins.kotlin.outputs.GetDigitalTwinResult.Companion.toKotlin as getDigitalTwinResultToKotlin
import com.pulumi.azurenative.digitaltwins.kotlin.outputs.GetDigitalTwinsEndpointResult.Companion.toKotlin as getDigitalTwinsEndpointResultToKotlin
import com.pulumi.azurenative.digitaltwins.kotlin.outputs.GetPrivateEndpointConnectionResult.Companion.toKotlin as getPrivateEndpointConnectionResultToKotlin
import com.pulumi.azurenative.digitaltwins.kotlin.outputs.GetTimeSeriesDatabaseConnectionResult.Companion.toKotlin as getTimeSeriesDatabaseConnectionResultToKotlin

public object DigitaltwinsFunctions {
    /**
     * Get DigitalTwinsInstances resource.
     * Azure REST API version: 2023-01-31.
     * Other available API versions: 2020-03-01-preview.
     * @param argument null
     * @return The description of the DigitalTwins service.
     */
    public suspend fun getDigitalTwin(argument: GetDigitalTwinPlainArgs): GetDigitalTwinResult =
        getDigitalTwinResultToKotlin(getDigitalTwinPlain(argument.toJava()).await())

    /**
     * @see [getDigitalTwin].
     * @param resourceGroupName The name of the resource group that contains the DigitalTwinsInstance.
     * @param resourceName The name of the DigitalTwinsInstance.
     * @return The description of the DigitalTwins service.
     */
    public suspend fun getDigitalTwin(resourceGroupName: String, resourceName: String): GetDigitalTwinResult {
        val argument = GetDigitalTwinPlainArgs(
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return getDigitalTwinResultToKotlin(getDigitalTwinPlain(argument.toJava()).await())
    }

    /**
     * @see [getDigitalTwin].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;digitaltwins&#46;kotlin&#46;inputs&#46;GetDigitalTwinPlainArgs].
     * @return The description of the DigitalTwins service.
     */
    public suspend fun getDigitalTwin(argument: suspend GetDigitalTwinPlainArgsBuilder.() -> Unit): GetDigitalTwinResult {
        val builder = GetDigitalTwinPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDigitalTwinResultToKotlin(getDigitalTwinPlain(builtArgument.toJava()).await())
    }

    /**
     * Get DigitalTwinsInstances Endpoint.
     * Azure REST API version: 2023-01-31.
     * Other available API versions: 2020-03-01-preview.
     * @param argument null
     * @return DigitalTwinsInstance endpoint resource.
     */
    public suspend fun getDigitalTwinsEndpoint(argument: GetDigitalTwinsEndpointPlainArgs): GetDigitalTwinsEndpointResult =
        getDigitalTwinsEndpointResultToKotlin(getDigitalTwinsEndpointPlain(argument.toJava()).await())

    /**
     * @see [getDigitalTwinsEndpoint].
     * @param endpointName Name of Endpoint Resource.
     * @param resourceGroupName The name of the resource group that contains the DigitalTwinsInstance.
     * @param resourceName The name of the DigitalTwinsInstance.
     * @return DigitalTwinsInstance endpoint resource.
     */
    public suspend fun getDigitalTwinsEndpoint(
        endpointName: String,
        resourceGroupName: String,
        resourceName: String,
    ): GetDigitalTwinsEndpointResult {
        val argument = GetDigitalTwinsEndpointPlainArgs(
            endpointName = endpointName,
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return getDigitalTwinsEndpointResultToKotlin(getDigitalTwinsEndpointPlain(argument.toJava()).await())
    }

    /**
     * @see [getDigitalTwinsEndpoint].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;digitaltwins&#46;kotlin&#46;inputs&#46;GetDigitalTwinsEndpointPlainArgs].
     * @return DigitalTwinsInstance endpoint resource.
     */
    public suspend fun getDigitalTwinsEndpoint(argument: suspend GetDigitalTwinsEndpointPlainArgsBuilder.() -> Unit): GetDigitalTwinsEndpointResult {
        val builder = GetDigitalTwinsEndpointPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDigitalTwinsEndpointResultToKotlin(getDigitalTwinsEndpointPlain(builtArgument.toJava()).await())
    }

    /**
     * Get private endpoint connection properties for the given private endpoint.
     * Azure REST API version: 2023-01-31.
     * Other available API versions: 2020-12-01.
     * @param argument null
     * @return The private endpoint connection of a Digital Twin.
     */
    public suspend fun getPrivateEndpointConnection(argument: GetPrivateEndpointConnectionPlainArgs): GetPrivateEndpointConnectionResult =
        getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())

    /**
     * @see [getPrivateEndpointConnection].
     * @param privateEndpointConnectionName The name of the private endpoint connection.
     * @param resourceGroupName The name of the resource group that contains the DigitalTwinsInstance.
     * @param resourceName The name of the DigitalTwinsInstance.
     * @return The private endpoint connection of a Digital Twin.
     */
    public suspend fun getPrivateEndpointConnection(
        privateEndpointConnectionName: String,
        resourceGroupName: String,
        resourceName: String,
    ): GetPrivateEndpointConnectionResult {
        val argument = GetPrivateEndpointConnectionPlainArgs(
            privateEndpointConnectionName = privateEndpointConnectionName,
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrivateEndpointConnection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;digitaltwins&#46;kotlin&#46;inputs&#46;GetPrivateEndpointConnectionPlainArgs].
     * @return The private endpoint connection of a Digital Twin.
     */
    public suspend fun getPrivateEndpointConnection(argument: suspend GetPrivateEndpointConnectionPlainArgsBuilder.() -> Unit): GetPrivateEndpointConnectionResult {
        val builder = GetPrivateEndpointConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the description of an existing time series database connection.
     * Azure REST API version: 2023-01-31.
     * @param argument null
     * @return Describes a time series database connection resource.
     */
    public suspend fun getTimeSeriesDatabaseConnection(argument: GetTimeSeriesDatabaseConnectionPlainArgs): GetTimeSeriesDatabaseConnectionResult =
        getTimeSeriesDatabaseConnectionResultToKotlin(getTimeSeriesDatabaseConnectionPlain(argument.toJava()).await())

    /**
     * @see [getTimeSeriesDatabaseConnection].
     * @param resourceGroupName The name of the resource group that contains the DigitalTwinsInstance.
     * @param resourceName The name of the DigitalTwinsInstance.
     * @param timeSeriesDatabaseConnectionName Name of time series database connection.
     * @return Describes a time series database connection resource.
     */
    public suspend fun getTimeSeriesDatabaseConnection(
        resourceGroupName: String,
        resourceName: String,
        timeSeriesDatabaseConnectionName: String,
    ): GetTimeSeriesDatabaseConnectionResult {
        val argument = GetTimeSeriesDatabaseConnectionPlainArgs(
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
            timeSeriesDatabaseConnectionName = timeSeriesDatabaseConnectionName,
        )
        return getTimeSeriesDatabaseConnectionResultToKotlin(getTimeSeriesDatabaseConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getTimeSeriesDatabaseConnection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;digitaltwins&#46;kotlin&#46;inputs&#46;GetTimeSeriesDatabaseConnectionPlainArgs].
     * @return Describes a time series database connection resource.
     */
    public suspend fun getTimeSeriesDatabaseConnection(argument: suspend GetTimeSeriesDatabaseConnectionPlainArgsBuilder.() -> Unit): GetTimeSeriesDatabaseConnectionResult {
        val builder = GetTimeSeriesDatabaseConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTimeSeriesDatabaseConnectionResultToKotlin(getTimeSeriesDatabaseConnectionPlain(builtArgument.toJava()).await())
    }
}
