@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.digitaltwins.kotlin

import com.pulumi.azurenative.digitaltwins.PrivateEndpointConnectionArgs.builder
import com.pulumi.azurenative.digitaltwins.kotlin.inputs.ConnectionPropertiesArgs
import com.pulumi.azurenative.digitaltwins.kotlin.inputs.ConnectionPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The private endpoint connection of a Digital Twin.
 * Azure REST API version: 2023-01-31. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2020-12-01.
 * ## Example Usage
 * ### Update the status of a private endpoint connection with the given name
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateEndpointConnection = new AzureNative.DigitalTwins.PrivateEndpointConnection("privateEndpointConnection", new()
 *     {
 *         PrivateEndpointConnectionName = "myPrivateConnection",
 *         Properties = new AzureNative.DigitalTwins.Inputs.ConnectionPropertiesArgs
 *         {
 *             PrivateLinkServiceConnectionState = new AzureNative.DigitalTwins.Inputs.ConnectionPropertiesPrivateLinkServiceConnectionStateArgs
 *             {
 *                 Description = "Approved by johndoe@company.com.",
 *                 Status = AzureNative.DigitalTwins.PrivateLinkServiceConnectionStatus.Approved,
 *             },
 *         },
 *         ResourceGroupName = "resRg",
 *         ResourceName = "myDigitalTwinsService",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/digitaltwins/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := digitaltwins.NewPrivateEndpointConnection(ctx, "privateEndpointConnection", &digitaltwins.PrivateEndpointConnectionArgs{
 * 			PrivateEndpointConnectionName: pulumi.String("myPrivateConnection"),
 * 			Properties: &digitaltwins.ConnectionPropertiesArgs{
 * 				PrivateLinkServiceConnectionState: &digitaltwins.ConnectionPropertiesPrivateLinkServiceConnectionStateArgs{
 * 					Description: pulumi.String("Approved by johndoe@company.com."),
 * 					Status:      pulumi.String(digitaltwins.PrivateLinkServiceConnectionStatusApproved),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("resRg"),
 * 			ResourceName:      pulumi.String("myDigitalTwinsService"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.digitaltwins.PrivateEndpointConnection;
 * import com.pulumi.azurenative.digitaltwins.PrivateEndpointConnectionArgs;
 * import com.pulumi.azurenative.digitaltwins.inputs.ConnectionPropertiesArgs;
 * import com.pulumi.azurenative.digitaltwins.inputs.ConnectionPropertiesPrivateLinkServiceConnectionStateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateEndpointConnection = new PrivateEndpointConnection("privateEndpointConnection", PrivateEndpointConnectionArgs.builder()
 *             .privateEndpointConnectionName("myPrivateConnection")
 *             .properties(ConnectionPropertiesArgs.builder()
 *                 .privateLinkServiceConnectionState(ConnectionPropertiesPrivateLinkServiceConnectionStateArgs.builder()
 *                     .description("Approved by johndoe@company.com.")
 *                     .status("Approved")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("resRg")
 *             .resourceName("myDigitalTwinsService")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:digitaltwins:PrivateEndpointConnection myPrivateConnection /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DigitalTwins/digitalTwinsInstances/{resourceName}/privateEndpointConnections/{privateEndpointConnectionName}
 * ```
 * @property privateEndpointConnectionName The name of the private endpoint connection.
 * @property properties The connection properties.
 * @property resourceGroupName The name of the resource group that contains the DigitalTwinsInstance.
 * @property resourceName The name of the DigitalTwinsInstance.
 */
public data class PrivateEndpointConnectionArgs(
    public val privateEndpointConnectionName: Output<String>? = null,
    public val properties: Output<ConnectionPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.digitaltwins.PrivateEndpointConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.digitaltwins.PrivateEndpointConnectionArgs =
        com.pulumi.azurenative.digitaltwins.PrivateEndpointConnectionArgs.builder()
            .privateEndpointConnectionName(privateEndpointConnectionName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PrivateEndpointConnectionArgs].
 */
@PulumiTagMarker
public class PrivateEndpointConnectionArgsBuilder internal constructor() {
    private var privateEndpointConnectionName: Output<String>? = null

    private var properties: Output<ConnectionPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    /**
     * @param value The name of the private endpoint connection.
     */
    @JvmName("rgsfxqgxkslkfxix")
    public suspend fun privateEndpointConnectionName(`value`: Output<String>) {
        this.privateEndpointConnectionName = value
    }

    /**
     * @param value The connection properties.
     */
    @JvmName("oyjwrbwjtkfaudtv")
    public suspend fun properties(`value`: Output<ConnectionPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group that contains the DigitalTwinsInstance.
     */
    @JvmName("nofvfmcuqxokgewr")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the DigitalTwinsInstance.
     */
    @JvmName("ngcakjlgytotdgfb")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value The name of the private endpoint connection.
     */
    @JvmName("ibqcyjlnpfucscus")
    public suspend fun privateEndpointConnectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateEndpointConnectionName = mapped
    }

    /**
     * @param value The connection properties.
     */
    @JvmName("fexriovgnslgyulx")
    public suspend fun properties(`value`: ConnectionPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument The connection properties.
     */
    @JvmName("oibpuugymuevcmmo")
    public suspend fun properties(argument: suspend ConnectionPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ConnectionPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group that contains the DigitalTwinsInstance.
     */
    @JvmName("dhjobhgebpgocqgi")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the DigitalTwinsInstance.
     */
    @JvmName("rssknfkwammfedvh")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    internal fun build(): PrivateEndpointConnectionArgs = PrivateEndpointConnectionArgs(
        privateEndpointConnectionName = privateEndpointConnectionName,
        properties = properties,
        resourceGroupName = resourceGroupName,
        resourceName = resourceName,
    )
}
